% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chemical-APIs-batch.R
\name{get_chemicals_in_list_batch}
\alias{get_chemicals_in_list_batch}
\title{Get chemicals in a given chemical list batch}
\usage{
get_chemicals_in_list_batch(
  list_names = NULL,
  API_key = NULL,
  rate_limit = 0L,
  verbose = FALSE
)
}
\arguments{
\item{list_names}{A list of names of chemical lists.}

\item{API_key}{The user-specific API key.}

\item{rate_limit}{Number of seconds to wait between each request}

\item{verbose}{A logical indicating if some “progress report” should be given.}
}
\value{
A named list of data.frames each containing chemicals in the
corresponding chemical lists.
}
\description{
Get chemicals in a given chemical list batch
}
\examples{
\dontshow{if (has_ctx_key() & is.na(ctx_key() == 'FAKE_KEY')) withAutoprint(\{ # examplesIf}
# Pull chemicals in lists for multiple lists
chemicals_in_lists <- get_chemicals_in_list_batch(list_names = c('CCL4', 'NATADB'))
\dontshow{\}) # examplesIf}
}
