% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chemical-APIs-batch.R
\name{get_chem_props_pred_batch}
\alias{get_chem_props_pred_batch}
\title{Get predicted physical-chemical property data via batch}
\usage{
get_chem_props_pred_batch(
  DTXSID = NULL,
  API_key = NULL,
  rate_limit = 0L,
  Server = chemical_api_server,
  verbose = FALSE
)
}
\arguments{
\item{DTXSID}{The chemical identifier DTXSID}

\item{API_key}{The user-specific API key}

\item{rate_limit}{Number of seconds to wait between each request}

\item{Server}{The root address for the API endpoint}

\item{verbose}{A logical indicating if some "progress report" should be given.}
}
\value{
A data.table of predicted physchem property data
}
\description{
Get predicted physical-chemical property data via batch
}
\examples{
\dontshow{if (FALSE) withAutoprint(\{ # examplesIf}
# Get predicted physchem properties for BPA and Caffeine
chem_props_pred <- get_chem_props_pred(DTXSID = c('DTXSID7020182',
                                                  'DTXSID0020232'))
\dontshow{\}) # examplesIf}
}
