% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{styles_breach_counts}
\alias{styles_breach_counts}
\title{Count covenant breaches by style under the bullet-debt scenario}
\usage{
styles_breach_counts(
  styles = c("core", "core_plus", "value_added", "opportunistic"),
  min_dscr_guard = 1.2,
  max_ltv_guard = 0.65
)
}
\arguments{
\item{styles}{Character vector of style names (e.g. \code{"core"}, \code{"core_plus"},
\code{"value_added"}, \code{"opportunistic"}). The output \code{style} factor will follow
this ordering.}

\item{min_dscr_guard}{Numeric scalar, DSCR guardrail below which a period is
counted as a DSCR breach.}

\item{max_ltv_guard}{Numeric scalar, forward-LTV guardrail above which a
period is counted as an LTV breach.}
}
\value{
A tibble with one row per style and the columns:
\itemize{
\item \code{style} (factor, levels = \code{styles}),
\item \code{n_dscr_breach}: number of years with \code{dscr < min_dscr_guard},
\item \code{n_ltv_breach}:  number of years with \code{ltv_forward > max_ltv_guard}.
Year 0 is excluded from the counts.
}
}
\description{
This helper aggregates, for a set of styles, the number of periods in which
bullet-debt credit metrics breach simple covenant guardrails:
\itemize{
\item DSCR < \code{min_dscr_guard},
\item forward LTV > \code{max_ltv_guard}.
}
}
\details{
It relies on \code{\link[=style_bullet_ratios]{style_bullet_ratios()}}, which is expected to return, for each
style, a tibble of yearly ratios in the bullet-debt scenario with at least
the columns: \code{style}, \code{year}, \code{dscr}, \code{ltv_forward}.
}
