% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cosCorr.R
\name{cosCorr}
\alias{cosCorr}
\title{Cosine-Correlation Coefficient Computation}
\usage{
cosCorr(x, na.rm = FALSE)
}
\arguments{
\item{x}{A numeric vector of length p >= 2, where x[1] should be 0 (representing t_1).
The remaining elements x[2], x[3], ..., x[p] represent the p-1 variables (t_2, t_3, ..., t_p).}

\item{na.rm}{Logical. If TRUE, NA values are removed before computation. Default is FALSE.}
}
\value{
A numeric value representing the cosine-correlation coefficient
  \eqn{\rho_{p-1}}{rho}.
  The coefficient ranges from 0 to 1, where higher values indicate greater
  linear dependence among the variables.
}
\description{
Computes the cosine-correlation coefficient for a vector of p-1 variables,
measuring the degree of linear dependence among variables in a multidimensional context.
}
\details{
The cosine-correlation coefficient is defined as:

\eqn{\rho_{p-1} = \frac{(p-1) \prod_{i=2}^{p} |t_i|}{\sum_{i=2}^{p} |t_i|^{p-1}}}{rho = [(p-1) * prod(|t_i|)] / sum(|t_i|^(p-1))}

where \eqn{t_1 = 0}{t_1 = 0} and \eqn{t_2, \ldots, t_p}{t_2, ..., t_p} are the variables within the system.
The coefficient serves as a measure of the degree of linear dependence among
the p-1 variables, providing a quantitative assessment of their interrelationships
within a multidimensional context.
}
\examples{
# Example 1: Simple vector
x <- c(0, 2, 3, 4)
cosCorr(x)

# Example 2: Vector with 5 variables
x <- c(0, 1, 2, 3, 4, 5)
cosCorr(x)

}
