% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robustness_tests.R
\name{test_jackknife_sectors}
\alias{test_jackknife_sectors}
\title{Jackknife robustness test by sector}
\usage{
test_jackknife_sectors(
  X_matrix,
  Y_matrix,
  sector_names = NULL,
  k_exclude = 3,
  max_comp = 3,
  verbose = TRUE
)
}
\arguments{
\item{X_matrix}{Matrix of first set of variables}

\item{Y_matrix}{Matrix of second set of variables}

\item{sector_names}{Vector of sector names (default: NULL)}

\item{k_exclude}{Number of sectors to exclude in each iteration (default: 3)}

\item{max_comp}{Maximum number of components (default: 3)}

\item{verbose}{Logical; print progress and diagnostic information. Default \code{TRUE}.}
}
\value{
List with components:
\describe{
\item{\code{jackknife_estimates}}{Matrix of lambda estimates (iterations x factors).}
\item{\code{original_estimate}}{Original lambda from full sample.}
\item{\code{bias}}{Estimated jackknife bias.}
\item{\code{se}}{Jackknife standard errors.}
\item{\code{influential_sectors}}{Character vector of highly influential sectors.}
\item{\code{dfbetas}}{Matrix of influence measures (DFBETAS).}
}
}
\description{
Assesses the influence of individual sectors by systematically dropping each
sector and re-estimating convergence parameters. Identifies influential
sectors and checks stability.
}
\details{
column names.
}
