% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/campaign_descriptions.R
\docType{data}
\name{campaign_descriptions}
\alias{campaign_descriptions}
\title{Campaign metadata.}
\format{
A data frame with 27 rows and 4 variables
\itemize{
\item campaign_id: Uniquely identifies each campaign; Ranges 1-27
\item campaign_type: Type of campaign (Type A, Type B, Type C)
\item start_date: Start date of campaign
\item end_date: End date of campaign
}
}
\source{
84.51°, Customer Journey study, \url{http://www.8451.com/area51/}
}
\usage{
campaign_descriptions
}
\value{
\item{campaign_descriptions}{a tibble}
}
\description{
Campaign metadata for all campaigns run for the Customer Journey study. This
dataset gives the length of time for which a campaign runs. So, any coupons
received as part of a campaign are valid within the dates contained in this
dataset.
}
\examples{
\donttest{
# full data set
campaign_descriptions

# Join product campaign metadata to campaign_table dataset
require("dplyr")
campaigns \%>\%
  left_join(campaign_descriptions, "campaign_id")
}
}
\keyword{datasets}
