\name{wpss_score}
\alias{wpss_score}
\title{
WPSS Classification for Myelodysplastic Syndrome
}
\description{
Calculates the WHO Classification-based Prognostic Scoring System (WPSS) score for Myelodysplastic Syndrome (MDS). The score predicts survival and the risk of leukemic evolution based on WHO classification, karyotype abnormalities, and transfusion requirement.
}
\usage{
wpss_score(who_classification, karyotype, transfusion_requirement)
}
\arguments{
  \item{who_classification}{
String. WHO subtype of MDS.
Options:
"rcud_rars_rcmd" (Refractory cytopenia with unilineage dysplasia, Refractory anemia with ringed sideroblasts, or Refractory cytopenia with multilineage dysplasia): 0 points.
"raeb_1" (Refractory anemia with excess blasts-1): 1 point.
"raeb_2" (Refractory anemia with excess blasts-2): 2 points.
}
  \item{karyotype}{
String. Cytogenetic risk group.
"good" (Normal, -Y, del(5q), del(20q)): 0 points.
"intermediate" (Other abnormalities): 1 point.
"poor" (Complex >=3 abnormalities, chromosome 7 anomalies): 2 points.
}
  \item{transfusion_requirement}{
String. Requirement for regular RBC transfusions.
"no": 0 points.
"regular": 1 point.
}
}
\value{
A list containing:
\item{WPSS_Score}{The calculated total score (Range 0-5).}
\item{Risk_Group}{Risk classification (Very Low, Low, Intermediate, High, Very High).}
\item{Median_Survival}{Estimated median survival time.}
\item{AML_Progression_Risk_2yr}{Estimated risk of progression to Acute Myeloid Leukemia at 2 years.}
}
\references{
Malcovati L, Germing U, Kuendgen A, et al. Time-dependent prognostic scoring system for predicting survival and leukemic evolution in myelodysplastic syndromes. J Clin Oncol. 2007;25(23):3503-3510. doi:10.1200/JCO.2006.08.5696
}
\examples{

# Example 1: Very Low Risk
# RCUD/RARS, Good karyotype, No transfusion
wpss_score("rcud_rars_rcmd", "good", "no")

# Example 2: High Risk
# RAEB-1 (1), Poor karyotype (2), Regular transfusion (1) -> Score 4
wpss_score("raeb_1", "poor", "regular")
}
