\name{wells_pe_score}
\alias{wells_pe_score}
\title{
Wells' Criteria for Pulmonary Embolism
}
\description{
Calculates the Wells' Criteria risk stratification score for Pulmonary Embolism (PE). The score stratifies patients into risk groups to guide diagnostic testing (e.g., D-dimer testing vs. CT Pulmonary Angiography).
}
\usage{
wells_pe_score(clinical_signs_dvt, pe_number_one_diagnosis, heart_rate,
               immobilization_surgery, previous_pe_dvt, hemoptysis, malignancy)
}
\arguments{
  \item{clinical_signs_dvt}{
Numeric (0 or 1). Clinical signs and symptoms of DVT (leg swelling and pain with palpation of deep veins). (1 = Yes, +3.0 points).
}
  \item{pe_number_one_diagnosis}{
Numeric (0 or 1). Is PE the #1 diagnosis or equally likely? (1 = Yes, +3.0 points).
}
  \item{heart_rate}{
Numeric. Heart rate in beats per minute. (>100 bpm adds +1.5 points).
}
  \item{immobilization_surgery}{
Numeric (0 or 1). Immobilization at least 3 days OR surgery in the previous 4 weeks. (1 = Yes, +1.5 points).
}
  \item{previous_pe_dvt}{
Numeric (0 or 1). Previous, objectively diagnosed PE or DVT. (1 = Yes, +1.5 points).
}
  \item{hemoptysis}{
Numeric (0 or 1). Presence of hemoptysis. (1 = Yes, +1.0 point).
}
  \item{malignancy}{
Numeric (0 or 1). Malignancy with treatment within 6 months or palliative. (1 = Yes, +1.0 point).
}
}
\value{
A list containing:
\item{Wells_Score}{The calculated total score.}
\item{Risk_Tier_3}{Risk classification based on the 3-tier model (Low < 2, Moderate 2-6, High > 6).}
\item{Risk_Tier_2}{Risk classification based on the 2-tier model (Unlikely <= 4, Likely > 4).}
}
\references{
Wells PS, Anderson DR, Rodger M, et al. Derivation of a simple clinical model to categorize patients probability of pulmonary embolism: increasing the models utility with the SimpliRED D-dimer. Thromb Haemost. 2000;83(3):416-420.
}
\examples{

# Example 1: High Risk
# Clinical signs (1), PE #1 Dx (1)
# Score = 6.0
wells_pe_score(1, 1, 80, 0, 0, 0, 0)

# Example 2: Moderate Risk
# HR 110 (1.5), Surgery (1.5)
# Score = 3.0
wells_pe_score(0, 0, 110, 1, 0, 0, 0)
}
