\name{vbac_success_predictor}
\alias{vbac_success_predictor}
\title{
Vaginal Birth After Cesarean (VBAC) Success Predictor (MFMU 2021 Model)
}
\description{
Calculates the predicted probability of a successful vaginal birth after cesarean (VBAC) for women with one prior low-transverse cesarean section. This function uses the updated 2021 MFMU Network model which excludes race and ethnicity variables, incorporating age, BMI, prior vaginal delivery history, recurring indication for prior cesarean, and history of chronic hypertension.
}
\usage{
vbac_success_predictor(age, height_in, weight_lb, previous_vaginal_delivery,
                       previous_vbac, recurring_indication_cesarean,
                       treated_chronic_hypertension)
}
\arguments{
  \item{age}{
Numeric. Maternal age in years.
}
  \item{height_in}{
Numeric. Maternal height in inches.
}
  \item{weight_lb}{
Numeric. Pre-pregnancy weight in pounds.
}
  \item{previous_vaginal_delivery}{
Numeric (0 or 1). Has the patient had any prior vaginal delivery (either before or after the cesarean)? (1 = Yes).
}
  \item{previous_vbac}{
Numeric (0 or 1). Has the patient had a successful VBAC previously? (1 = Yes).
}
  \item{recurring_indication_cesarean}{
Numeric (0 or 1). Was the indication for the prior cesarean section a recurring cause (e.g., arrest of dilation or descent)? (1 = Yes).
}
  \item{treated_chronic_hypertension}{
Numeric (0 or 1). Is the patient being treated for chronic hypertension? (1 = Yes).
}
}
\details{
The probability (\eqn{P}) is calculated using the logistic regression equation from the 2021 validation study:
\deqn{P = \frac{1}{1 + e^{-x}}}
Where \eqn{x = 3.302 - 0.043(Age) - 0.052(BMI) + 0.832(AnyVaginal) + 0.489(PriorVBAC) - 0.622(RecurringIndication) - 0.513(Hypertension)}.
}
\value{
A list containing:
\item{Predicted_VBAC_Success}{The estimated percentage chance of a successful vaginal delivery.}
}
\references{
Grobman WA, et al. Prediction of Vaginal Birth After Cesarean Delivery in Term Gestations: A Calculator Without Race and Ethnicity. Am J Obstet Gynecol. 2021;225(6):664.e1-664.e7. doi:10.1016/j.ajog.2021.05.021
}
\examples{

# Example 1: High Probability
# 30yo, BMI ~24, Prior VBAC, Non-recurring indication
vbac_success_predictor(30, 65, 145, 1, 1, 0, 0)

# Example 2: Lower Probability
# 35yo, BMI ~35, No prior vaginal, Recurring indication (arrest), Hypertension
vbac_success_predictor(35, 64, 205, 0, 0, 1, 1)
}
