\name{utah_covid_risk_score}
\alias{utah_covid_risk_score}
\title{
Utah COVID-19 Risk Score
}
\description{
Calculates the Utah COVID-19 Risk Score to predict the probability of hospitalization in patients with COVID-19. The score uses age, sex, and comorbidities to stratify patients into Low, Medium, or High risk categories.
}
\usage{
utah_covid_risk_score(age, sex, congestive_heart_failure, copd, diabetes,
                      hypertension, immunosuppression)
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
18-39: 0 pts
40-49: 1 pt
50-59: 2 pts
60-69: 3 pts
70-79: 4 pts
>=80: 5 pts
}
  \item{sex}{
String. Patient sex ("Male" or "Female"). (Male: +1 pt).
}
  \item{congestive_heart_failure}{
Numeric (0 or 1). History of congestive heart failure. (1 = Yes, +1 pt).
}
  \item{copd}{
Numeric (0 or 1). History of COPD. (1 = Yes, +1 pt).
}
  \item{diabetes}{
Numeric (0 or 1). History of diabetes. (1 = Yes, +1 pt).
}
  \item{hypertension}{
Numeric (0 or 1). History of hypertension. (1 = Yes, +1 pt).
}
  \item{immunosuppression}{
Numeric (0 or 1). Immunocompromised state (e.g., cancer treatment, solid organ transplant, immunodeficiencies). (1 = Yes, +1 pt).
}
}
\value{
A list containing:
\item{Utah_Risk_Score}{The calculated total score (Range 0-11).}
\item{Risk_Level}{Risk classification (Low <= 0, Medium 1-2, High >= 3).}
}
\references{
Knight SR, Ho A, Pius R, et al. Risk stratification of patients admitted to hospital with covid-19 using the ISARIC WHO Clinical Characterisation Protocol: development and validation of the 4C Mortality Score. BMJ. 2020;370:m3339. (Context of similar risk stratification approaches).
Review of Utah Healthcare Guidance.
}
\examples{

# Example 1: High Risk
# 75yo Male (+4 Age, +1 Sex), Hypertension (+1)
# Score = 6
utah_covid_risk_score(75, "male", 0, 0, 0, 1, 0)

# Example 2: Low Risk
# 30yo Female, No comorbidities
# Score = 0
utah_covid_risk_score(30, "female", 0, 0, 0, 0, 0)
}
