\name{tokyo_guidelines_cholecystitis_2018}
\alias{tokyo_guidelines_cholecystitis_2018}
\title{
Tokyo Guidelines 2018 (TG18) for Acute Cholecystitis
}
\description{
Diagnoses and grades the severity of acute cholecystitis based on the 2018 Tokyo Guidelines. The assessment involves three diagnostic criteria categories (Local signs, Systemic signs, Imaging) and specific severity grading criteria based on organ dysfunction and local inflammation.
}
\usage{
tokyo_guidelines_cholecystitis_2018(murphys_sign, ruq_tenderness, temperature_c,
                                    wbc_count, crp_elevated, imaging_positive,
                                    hypotension_meds, altered_consciousness,
                                    pao2_fio2_ratio, creatinine_mg_dl, inr,
                                    platelet_count, palpable_mass, duration_gt_72h,
                                    marked_local_inflammation)
}
\arguments{
  \item{murphys_sign}{
Numeric (0 or 1). Positive Murphy's sign. (1 = Yes).
}
  \item{ruq_tenderness}{
Numeric (0 or 1). Right upper quadrant tenderness or pain. (1 = Yes).
}
  \item{temperature_c}{
Numeric. Body temperature in Celsius. (> 38.0 contributes to diagnosis).
}
  \item{wbc_count}{
Numeric. White Blood Cell count (x10^3/uL). (> 10 contributes to diagnosis; > 18 contributes to Grade II).
}
  \item{crp_elevated}{
Numeric (0 or 1). Elevated C-Reactive Protein (>= 3 mg/dL). (1 = Yes).
}
  \item{imaging_positive}{
Numeric (0 or 1). Imaging findings characteristic of acute cholecystitis. (1 = Yes).
}
  \item{hypotension_meds}{
Numeric (0 or 1). Hypotension requiring dopamine >= 5 mcg/kg/min or any dose of norepinephrine/dobutamine. (1 = Yes, Grade III).
}
  \item{altered_consciousness}{
Numeric (0 or 1). Disturbance of consciousness. (1 = Yes, Grade III).
}
  \item{pao2_fio2_ratio}{
Numeric. PaO2/FiO2 ratio. (< 300 contributes to Grade III). Use NA if not available.
}
  \item{creatinine_mg_dl}{
Numeric. Serum Creatinine. (> 2.0 mg/dL contributes to Grade III).
}
  \item{inr}{
Numeric. International Normalized Ratio. (> 1.5 contributes to Grade III).
}
  \item{platelet_count}{
Numeric. Platelet count (x10^3/uL). (< 100 contributes to Grade III).
}
  \item{palpable_mass}{
Numeric (0 or 1). Palpable tender mass in the right upper quadrant. (1 = Yes, Grade II).
}
  \item{duration_gt_72h}{
Numeric (0 or 1). Duration of complaints > 72 hours. (1 = Yes, Grade II).
}
  \item{marked_local_inflammation}{
Numeric (0 or 1). Marked local inflammation (e.g., gangrenous/emphysematous cholecystitis, abscess, biliary peritonitis). (1 = Yes, Grade II).
}
}
\value{
A list containing:
\item{Diagnosis}{Diagnostic status (No, Suspected, or Definite Acute Cholecystitis).}
\item{Severity_Grade}{Severity Classification (Grade I, II, or III) if diagnosed.}
\item{Criteria_Met}{List indicating which diagnostic criteria categories (A, B, C) were fulfilled.}
}
\references{
Yokoe M, Hata J, Takada T, et al. Tokyo Guidelines 2018: diagnostic criteria and severity grading of acute cholecystitis (with videos). J Hepatobiliary Pancreat Sci. 2018;25(1):41-54. doi:10.1002/jhbp.515
}
\examples{

# Example 1: Definite Acute Cholecystitis, Grade II
# Murphy (+), Fever 38.5, WBC 19, Imaging (+), No organ failure, Duration < 72h
tokyo_guidelines_cholecystitis_2018(1, 1, 38.5, 19, 1, 1, 0, 0, 400, 1.0, 1.0, 200, 0, 0, 0)

# Example 2: Suspected Acute Cholecystitis, Grade I
# RUQ pain (+), Fever 38.2, WBC 11, Imaging (-), No severity features
tokyo_guidelines_cholecystitis_2018(0, 1, 38.2, 11, 0, 0, 0, 0, NA, 0.8, 1.0, 250, 0, 0, 0)
}
