\name{stone_ureteral_score}
\alias{stone_ureteral_score}
\title{
STONE Score for Uncomplicated Ureteral Stone
}
\description{
Calculates the STONE Score to predict the likelihood of an uncomplicated ureteral stone in patients presenting with flank pain. This score can help reduce radiation exposure by identifying patients with a high probability of ureteral stones who may not require immediate CT imaging.
}
\usage{
stone_ureteral_score(sex, duration_of_pain_hours, race, nausea_vomiting,
                     hematuria_on_dipstick)
}
\arguments{
  \item{sex}{
String. Patient sex ("Male" or "Female"). (Male adds 2 points).
}
  \item{duration_of_pain_hours}{
Numeric. Duration of pain prior to presentation in hours.
<6 hours: +3 pts.
6-24 hours: +1 pt.
>24 hours: 0 pts.
}
  \item{race}{
String. Patient race ("Black" or "Non_Black"). (Non-Black adds 3 points).
}
  \item{nausea_vomiting}{
Numeric (0, 1, or -1 if specified "none" but usually N/V is present vs absent).
Here: Nausea alone = 1 pt, Vomiting = 2 pts, None = 0 pts.
(Note: MDCalc implementation often simplifies to Nausea/Vomiting vs None, but original derivation uses graded points: Nausea +1, Vomiting +2).
Wait, re-checking standard scoring:
Nausea alone: 1 pt.
Vomiting: 2 pts.
None: 0 pts.
Let's assume input 0=None, 1=Nausea, 2=Vomiting.
}
  \item{hematuria_on_dipstick}{
Numeric (0 or 1). Presence of hematuria on urine dipstick. (1 = Yes, +3 points).
}
}
\value{
A list containing:
\item{STONE_Score}{The calculated total score (Range 0-13).}
\item{Risk_Category}{Classification (Low, Moderate, High).}
\item{Ureteral_Stone_Probability}{Estimated probability of ureteral stone presence.}
}
\references{
Moore CL, Bomann S, Daniels B, et al. Derivation and validation of a clinical prediction rule for uncomplicated ureteral stone—the STONE score: retrospective and prospective validation. BMJ. 2014;348:g2191. doi:10.1136/bmj.g2191
}
\examples{

# Example 1: High Probability
# Male (+2), Pain <6h (+3), Non-Black (+3), Vomiting (+2), Hematuria (+3)
# Score = 13
stone_ureteral_score("male", 4, "non_black", 2, 1)

# Example 2: Low Probability
# Female (0), Pain >24h (0), Black (0), No N/V (0), No Hematuria (0)
# Score = 0
stone_ureteral_score("female", 30, "black", 0, 0)
}
