\name{simplified_aih_score}
\alias{simplified_aih_score}
\title{
Simplified Autoimmune Hepatitis (AIH) Score
}
\description{
Calculates the Simplified AIH Score (2008) to aid in the diagnosis of Autoimmune Hepatitis. The score is based on four parameters: autoantibodies, IgG levels, liver histology, and the absence of viral hepatitis.
}
\usage{
simplified_aih_score(ana_or_sma_titer, lkm_titer, sla_antibody_positive,
                     igg_level, igg_uln, liver_histology, viral_hepatitis_absent)
}
\arguments{
  \item{ana_or_sma_titer}{
String. Titer of ANA or SMA antibodies. Options: "none", ">=1:40", ">=1:80".
}
  \item{lkm_titer}{
String. Titer of LKM antibodies. Options: "none", ">=1:40".
}
  \item{sla_antibody_positive}{
Numeric (0 or 1). Presence of Soluble Liver Antigen (SLA) antibodies. (1 = Positive).
}
  \item{igg_level}{
Numeric. Patient's serum IgG level.
}
  \item{igg_uln}{
Numeric. Upper Limit of Normal for IgG level in the lab.
}
  \item{liver_histology}{
String. Histological findings. Options: "typical" (interface hepatitis, emperipolesis, rosettes), "compatible" (chronic hepatitis without all typical features), "atypical" (signs of another diagnosis).
}
  \item{viral_hepatitis_absent}{
Numeric (0 or 1). Absence of viral hepatitis markers (A, B, C). (1 = Yes, markers absent).
}
}
\value{
A list containing:
\item{Simplified_AIH_Score}{The calculated total score (Range 0-8).}
\item{Diagnosis}{Interpretation (Probable AIH >= 6, Definite AIH >= 7).}
}
\references{
Hennes EM, Zeniya M, Czaja AJ, et al. Simplified criteria for the diagnosis of autoimmune hepatitis. Hepatology. 2008;48(1):169-176. doi:10.1002/hep.22322
}
\examples{

# Example 1: Definite AIH
# ANA >=1:80 (2), IgG >1.1x ULN (2), Typical Histology (2), No Viral Hep (2)
# Score = 8
simplified_aih_score(">=1:80", "none", 0, 1800, 1500, "typical", 1)

# Example 2: Probable AIH
# ANA >=1:40 (1), IgG Normal (0), Compatible Histology (1), No Viral Hep (2)
# Score = 4 (Not Diagnostic - Wait, calculation: 1+0+1+2 = 4. Correct.)
simplified_aih_score(">=1:40", "none", 0, 1000, 1500, "compatible", 1)

# Example 3: Probable AIH (Score 6)
# ANA >=1:40 (1), IgG >1.1x (2), Compatible (1), No Viral (2) -> 6
simplified_aih_score(">=1:40", "none", 0, 1800, 1500, "compatible", 1)
}
