\name{sich_score}
\alias{sich_score}
\title{
Secondary Intracerebral Hemorrhage (sICH) Score
}
\description{
Calculates the sICH score to predict the likelihood of an underlying vascular etiology (e.g., AVM, aneurysm, fistula) in patients with non-traumatic intracerebral hemorrhage. The score guides the decision to perform further vascular imaging (CTA, MRA, or DSA).
}
\usage{
sich_score(ncct_probability, age, sex, history_hypertension, impaired_coagulation)
}
\arguments{
  \item{ncct_probability}{
String. Assessment of vascular cause probability based on Non-Contrast CT.
"high": Enlarged vessels, calcifications along margins, or venous sinus hyperattenuation (2 pts).
"indeterminate": Unusual shape, edema disproportionate to time, or isolated subarachnoid hemorrhage (1 pt).
"low": Typical deep/ganglionic hemorrhage without above features (0 pts).
}
  \item{age}{
Numeric. Patient age in years.
18-45: 2 pts.
46-70: 1 pt.
>=71: 0 pts.
}
  \item{sex}{
String. "Male" (0 pts) or "Female" (1 pt).
}
  \item{history_hypertension}{
Numeric (0 or 1). History of hypertension. (0 = No, 1 = Yes).
}
  \item{impaired_coagulation}{
Numeric (0 or 1). Impaired coagulation (e.g., INR > 3, antiplatelet therapy). (0 = No, 1 = Yes).
Note: The score adds 1 point if *neither* hypertension *nor* impaired coagulation is present.
}
}
\value{
A list containing:
\item{sICH_Score}{The calculated score (Range 0-6).}
\item{Risk_Probability}{Estimated probability of a vascular etiology.}
\item{Recommendation}{Guidance on the need for vascular imaging.}
}
\references{
Delgado Almandoz JE, Schaefer PW, Goldstein JN, et al. Practical scoring system for the identification of patients with intracerebral hemorrhage at highest risk of harboring an underlying vascular etiology: the Secondary Intracerebral Hemorrhage Score. AJNR Am J Neuroradiol. 2010;31(9):1653-1660. doi:10.3174/ajnr.A2156
}
\examples{

# Example 1: High Risk
# High NCCT probability (+2), 30yo (+2), Female (+1), No HTN/Coag (+1)
# Score = 6
sich_score("high", 30, "female", 0, 0)

# Example 2: Low Risk
# Low NCCT (0), 75yo (0), Male (0), History of HTN (0 pts for 'neither' condition)
# Score = 0
sich_score("low", 75, "male", 1, 0)
}
