\name{shock_index}
\alias{shock_index}
\title{
Shock Index (SI)
}
\description{
Calculates the Shock Index (SI), a bedside assessment tool used to evaluate the hemodynamic stability of patients, particularly in trauma or acute critical illness. It is defined as the ratio of heart rate to systolic blood pressure.
}
\usage{
shock_index(heart_rate, systolic_bp)
}
\arguments{
  \item{heart_rate}{
Numeric. Heart rate in beats per minute (bpm).
}
  \item{systolic_bp}{
Numeric. Systolic blood pressure in mmHg.
}
}
\details{
The formula is:
\deqn{SI = \frac{HR}{SBP}}
Normal values typically range from 0.5 to 0.7. Values > 0.9 are associated with increased risk of mortality, need for massive transfusion, and occult shock even when blood pressure appears normal.
}
\value{
A list containing:
\item{Shock_Index}{The calculated index value.}
\item{Interpretation}{Clinical context regarding the score (Normal, Elevated, High).}
}
\references{
Allgöwer M, Burri C. Shock index. Dtsch Med Wochenschr. 1967;43:1-10.
Rady MY, Smithline HA, Blake H, Nowak R, Rivers E. A comparison of the shock index and ordinary vital signs to identify trauma patients with extensive major injury. Ann Emerg Med. 1994;24(4):685-690.
}
\examples{

# Example 1: Normal
# HR 70, SBP 120
# SI = 0.58
shock_index(70, 120)

# Example 2: High Risk (Occult Shock)
# HR 110, SBP 100
# SI = 1.1
shock_index(110, 100)
}
