\name{shapiro_rule_bacteremia}
\alias{shapiro_rule_bacteremia}
\title{
Shapiro Rule for Bacteremia
}
\description{
Calculates the Shapiro Rule result to determine if blood cultures are indicated for a febrile patient in the emergency department. The rule identifies patients at high risk for bacteremia based on major and minor criteria. Blood cultures are recommended if at least one Major criterion or at least two Minor criteria are present.
}
\usage{
shapiro_rule_bacteremia(age, shaking_chills, vomiting, temperature_c, systolic_bp,
                        wbc_count, creatinine, bands_percent, platelet_count,
                        suspected_endocarditis, indwelling_vascular_catheter)
}
\arguments{
  \item{age}{
Numeric. Patient age in years. (> 65 years is a Minor criterion).
}
  \item{shaking_chills}{
Numeric (0 or 1). Presence of shaking chills (rigors). (1 = Yes, Minor criterion).
}
  \item{vomiting}{
Numeric (0 or 1). Presence of vomiting. (1 = Yes, Minor criterion).
}
  \item{temperature_c}{
Numeric. Body temperature in degrees Celsius. (> 39.4 C is a Major criterion).
}
  \item{systolic_bp}{
Numeric. Systolic blood pressure in mmHg. (< 90 mmHg is a Minor criterion).
}
  \item{wbc_count}{
Numeric. White blood cell count in cells/uL. (> 18,000 is a Minor criterion).
}
  \item{creatinine}{
Numeric. Serum creatinine in mg/dL. (> 2.0 mg/dL is a Minor criterion).
}
  \item{bands_percent}{
Numeric. Percentage of band forms (neutrophils). (> 5\% is a Minor criterion).
}
  \item{platelet_count}{
Numeric. Platelet count in cells/uL. (< 150,000 is a Minor criterion).
}
  \item{suspected_endocarditis}{
Numeric (0 or 1). Clinical suspicion of endocarditis. (1 = Yes, Major criterion).
}
  \item{indwelling_vascular_catheter}{
Numeric (0 or 1). Presence of an indwelling vascular catheter. (1 = Yes, Major criterion).
}
}
\value{
A list containing:
\item{Recommendation}{Guidance on whether blood cultures are indicated.}
\item{Major_Criteria_Met}{Count of major criteria met.}
\item{Minor_Criteria_Met}{Count of minor criteria met.}
}
\references{
Shapiro NI, Wolfe RE, Wright SB, Moore R, Bates DW. Who needs a blood culture? A prospectively derived and validated prediction rule. J Emerg Med. 2008;35(3):255-264. doi:10.1016/j.jemermed.2007.08.056
}
\examples{

# Example 1: Indicated (1 Major)
# Suspected Endocarditis
shapiro_rule_bacteremia(40, 0, 0, 38.0, 120, 10000, 1.0, 0, 200000, 1, 0)

# Example 2: Indicated (2 Minor)
# Age 70, Vomiting
shapiro_rule_bacteremia(70, 0, 1, 38.0, 120, 10000, 1.0, 0, 200000, 0, 0)

# Example 3: Not Indicated
# 40yo, Fever 38.5, no other signs
shapiro_rule_bacteremia(40, 0, 0, 38.5, 120, 10000, 1.0, 0, 200000, 0, 0)
}
