\name{score2_op_risk}
\alias{score2_op_risk}
\title{
SCORE2-OP Risk Prediction Algorithm (Older Persons)
}
\description{
Calculates the 10-year risk of fatal and non-fatal cardiovascular disease (CVD) events in individuals aged 70-89 years, using the SCORE2-OP algorithm. This model accounts for the competing risk of non-CVD mortality in older populations and is calibrated for four European risk regions.
}
\usage{
score2_op_risk(sex, age, smoking_status, systolic_bp, total_cholesterol,
               hdl_cholesterol = NULL, region_risk_level = "low")
}
\arguments{
  \item{sex}{
String. Patient sex ("Male" or "Female").
}
  \item{age}{
Numeric. Patient age in years (70-89).
}
  \item{smoking_status}{
Numeric (0 or 1). Current smoker status. (1 = Yes).
}
  \item{systolic_bp}{
Numeric. Systolic blood pressure in mmHg.
}
  \item{total_cholesterol}{
Numeric. Total cholesterol level in mmol/L or mg/dL. (If >15, assumed mg/dL and converted).
}
  \item{hdl_cholesterol}{
Numeric (Optional). HDL cholesterol level in mmol/L or mg/dL. Used to calculate non-HDL cholesterol.
}
  \item{region_risk_level}{
String. Risk region classification. Options: "low", "moderate", "high", "very_high".
}
}
\value{
A list containing:
\item{SCORE2_OP_Risk_10yr}{The estimated 10-year risk of fatal/non-fatal CVD.}
\item{Risk_Category}{Risk classification based on age-specific thresholds for older persons (<7.5per Low-Moderate, 7.5-15per High, >=15per Very High).}
}
\references{
SCORE2-OP working group and ESC Cardiovascular Risk Collaboration. SCORE2-OP risk prediction algorithms: estimating incident cardiovascular event risk in older persons in four geographical risk regions. Eur Heart J. 2021;42(25):2455-2467. doi:10.1093/eurheartj/ehab312
}
\examples{

# Example 1: High Risk (75yo Male)
# Male, 75yo, Smoker, SBP 150, Total Chol 5.0 mmol/L, HDL 1.0, High Risk Region
score2_op_risk("male", 75, 1, 150, 5.0, 1.0, "high")

# Example 2: Low-to-Moderate Risk (80yo Female)
# Female, 80yo, Non-smoker, SBP 130, Total Chol 180 mg/dL, Low Risk Region
score2_op_risk("female", 80, 0, 130, 180, NULL, "low")
}
