\name{rope_risk_score}
\alias{rope_risk_score}
\title{
Risk of Paradoxical Embolism (RoPE) Score
}
\description{
Calculates the RoPE Score to estimate the probability that a cryptogenic stroke is related to a Patent Foramen Ovale (PFO). The score ranges from 0 to 10, with higher scores indicating a higher PFO-attributable fraction (i.e., it is more likely the PFO caused the stroke rather than being an incidental finding).
}
\usage{
rope_risk_score(age, history_hypertension, history_diabetes,
                history_stroke_tia, current_smoker, cortical_infarct)
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
18-29: +5 pts
30-39: +4 pts
40-49: +3 pts
50-59: +2 pts
60-69: +1 pt
>=70: 0 pts
}
  \item{history_hypertension}{
Numeric (0 or 1). History of hypertension. (0 = No [+1 pt], 1 = Yes [0 pts]).
}
  \item{history_diabetes}{
Numeric (0 or 1). History of diabetes. (0 = No [+1 pt], 1 = Yes [0 pts]).
}
  \item{history_stroke_tia}{
Numeric (0 or 1). History of prior stroke or TIA. (0 = No [+1 pt], 1 = Yes [0 pts]).
}
  \item{current_smoker}{
Numeric (0 or 1). Current smoker. (0 = No [+1 pt], 1 = Yes [0 pts]).
}
  \item{cortical_infarct}{
Numeric (0 or 1). Cortical infarct present on imaging. (1 = Yes [+1 pt], 0 = No [0 pts]).
}
}
\value{
A list containing:
\item{RoPE_Score}{The calculated total score (Range 0-10).}
\item{PFO_Attributable_Fraction}{The estimated probability that the stroke is PFO-related.}
\item{Stroke_Recurrence_Risk}{General risk category for 2-year stroke recurrence.}
}
\references{
Kent DM, Ruthazer R, Weimar C, et al. An index to identify stroke-related vs incidental patent foramen ovale in cryptogenic stroke. Neurology. 2013;81(7):619-625. doi:10.1212/WNL.0b013e3182a08d59
}
\examples{

# Example 1: High Probability of PFO-related stroke
# 35yo, No HTN, No DM, No Prior Stroke, Non-smoker, Cortical Infarct
# Score: 4(age) + 1(HTN) + 1(DM) + 1(Hx) + 1(Smoke) + 1(Cortical) = 9
rope_risk_score(35, 0, 0, 0, 0, 1)

# Example 2: Low Probability (Incidental PFO likely)
# 65yo, HTN, Smoker, Prior Stroke
# Score: 1(age) + 0 + 1(DM) + 0 + 0 + 0(Subcortical) = 2
rope_risk_score(65, 1, 0, 1, 1, 0)
}
