\name{rome_iv_functional_globus}
\alias{rome_iv_functional_globus}
\title{
Rome IV Diagnostic Criteria for Functional Globus
}
\description{
Evaluates the Rome IV criteria for diagnosing Functional Globus (formerly Globus Hystericus). Diagnosis requires a sensation of a lump or foreign body in the throat that is constant or intermittent, occurs between meals, does not interfere with swallowing, and cannot be explained by structural or reflux disease. Symptoms must be chronic (onset >= 6 months, active >= 3 months).
}
\usage{
rome_iv_functional_globus(sensation_constant_intermittent, localized_anteriorly,
                          no_dysphagia_odynophagia, no_gerd_explanation,
                          no_structural_pathology, symptom_onset_ge_6_months,
                          symptoms_active_last_3_months)
}
\arguments{
  \item{sensation_constant_intermittent}{
Numeric (0 or 1). Sensation of a lump, foreign body, or throat tightness that is constant or intermittent. (1 = Yes).
}
  \item{localized_anteriorly}{
Numeric (0 or 1). Is the sensation localized in the anterior neck? (1 = Yes).
}
  \item{no_dysphagia_odynophagia}{
Numeric (0 or 1). Absence of dysphagia (difficulty swallowing) or odynophagia (painful swallowing). (1 = Yes).
}
  \item{no_gerd_explanation}{
Numeric (0 or 1). Symptoms are NOT exclusively occurring during episodes of heartburn or regurgitation, and GERD is excluded as the cause. (1 = Yes).
}
  \item{no_structural_pathology}{
Numeric (0 or 1). Absence of structural pathology (e.g., mass, inflammation) on appropriate evaluation (e.g., EGD, barium swallow). (1 = Yes).
}
  \item{symptom_onset_ge_6_months}{
Numeric (0 or 1). Did symptom onset occur at least 6 months prior to diagnosis? (1 = Yes).
}
  \item{symptoms_active_last_3_months}{
Numeric (0 or 1). Have symptoms been active for the last 3 months? (1 = Yes).
}
}
\value{
A list containing:
\item{Diagnosis}{"Criteria Met for Functional Globus" or "Criteria Not Met".}
}
\references{
Aben-Fawaz H, Kahrilas PJ, Chen J. Esophageal disorders. Gastroenterology. 2016;150:1367-1379. doi:10.1053/j.gastro.2016.02.002
}
\examples{

# Example 1: Diagnosis Met
# Lump sensation (1), Anterior (1), No dysphagia (1), No GERD (1), No pathology (1), Chronic
rome_iv_functional_globus(1, 1, 1, 1, 1, 1, 1)

# Example 2: Not Met (Has dysphagia)
# Lump sensation (1), Anterior (1), Dysphagia present (0)
rome_iv_functional_globus(1, 1, 0, 1, 1, 1, 1)
}
