\name{rome_iv_cyclic_vomiting_syndrome}
\alias{rome_iv_cyclic_vomiting_syndrome}
\title{
Rome IV Diagnostic Criteria for Cyclic Vomiting Syndrome (CVS)
}
\description{
Evaluates the Rome IV diagnostic criteria for Cyclic Vomiting Syndrome (CVS). Diagnosis requires stereotypical episodes of acute onset vomiting lasting less than 1 week, occurring at least 3 times in the prior year, with absence of vomiting between episodes. Symptoms must have started at least 6 months ago and be active within the last 3 months.
}
\usage{
rome_iv_cyclic_vomiting_syndrome(stereotypical_episodes, episode_count_12mo,
                                 episodes_separated_1wk, inter_episodic_wellness,
                                 symptom_onset_6mo, active_symptoms_3mo)
}
\arguments{
  \item{stereotypical_episodes}{
Numeric (0 or 1). Are episodes stereotypical regarding onset (acute) and duration (< 1 week)? (1 = Yes).
}
  \item{episode_count_12mo}{
Numeric. Number of discrete episodes in the prior year. (Must be >= 3).
}
  \item{episodes_separated_1wk}{
Numeric (0 or 1). Did the episodes occur at least 1 week apart? (1 = Yes).
}
  \item{inter_episodic_wellness}{
Numeric (0 or 1). Is there an absence of vomiting between episodes? (1 = Yes).
}
  \item{symptom_onset_6mo}{
Numeric (0 or 1). Did symptoms onset at least 6 months ago? (1 = Yes).
}
  \item{active_symptoms_3mo}{
Numeric (0 or 1). Have criteria been fulfilled for the last 3 months? (1 = Yes).
}
}
\value{
A list containing:
\item{Diagnosis}{"Criteria Met for Cyclic Vomiting Syndrome (CVS)" or "Criteria Not Met".}
}
\references{
Stanghellini V, Chan FK, Hasler WL, et al. Gastroduodenal Disorders. Gastroenterology. 2016;150:1380-1392. doi:10.1053/j.gastro.2016.02.011
}
\examples{

# Example 1: Criteria Met
# Stereotypical(1), 4 episodes, Separated(1), Wellness(1), Duration met
rome_iv_cyclic_vomiting_syndrome(1, 4, 1, 1, 1, 1)

# Example 2: Not Met (Insufficient episodes)
# Stereotypical(1), 2 episodes, Separated(1), Wellness(1), Duration met
rome_iv_cyclic_vomiting_syndrome(1, 2, 1, 1, 1, 1)
}
