\name{rome_iv_child_nausea_vomiting}
\alias{rome_iv_child_nausea_vomiting}
\title{
Rome IV Diagnostic Criteria for Functional Nausea and Vomiting (Child/Adolescent)
}
\description{
Evaluates the Rome IV criteria for diagnosing functional nausea and vomiting in children and adolescents. Diagnosis requires bothersome nausea or vomiting at least twice a week for at least 2 months, exclusion of self-induced vomiting, eating disorders, and other medical explanations.
}
\usage{
rome_iv_child_nausea_vomiting(bothersome_nausea_frequency,
                              bothersome_vomiting_frequency, self_induced_vomiting,
                              eating_disorder, medical_condition_explained)
}
\arguments{
  \item{bothersome_nausea_frequency}{
Numeric. Frequency of bothersome nausea.
0: Never/Rarely.
1: Once a week.
2: Twice a week or more.
}
  \item{bothersome_vomiting_frequency}{
Numeric. Frequency of bothersome vomiting.
0: Never/Rarely.
1: Once a week.
2: Twice a week or more.
}
  \item{self_induced_vomiting}{
Numeric (0 or 1). Is the vomiting self-induced? (1 = Yes).
}
  \item{eating_disorder}{
Numeric (0 or 1). Can symptoms be explained by an eating disorder? (1 = Yes).
}
  \item{medical_condition_explained}{
Numeric (0 or 1). Can symptoms be explained by another medical condition (e.g., anatomic, metabolic, neoplastic)? (1 = Yes).
}
}
\value{
A list containing:
\item{Diagnosis}{"Criteria Met" or "Criteria Not Met".}
\item{Criteria_Check}{Boolean breakdown of symptom threshold and exclusion criteria.}
}
\references{
Hyams JS, Di Lorenzo C, Saps M, et al. Functional Disorders: Children and Adolescents. Gastroenterology. 2016;150:1456-1468. doi:10.1053/j.gastro.2016.02.015
}
\examples{

# Example 1: Diagnosis Met
# Nausea 2x/week (2), No vomiting (0), No exclusions
rome_iv_child_nausea_vomiting(2, 0, 0, 0, 0)

# Example 2: Not Met (Eating Disorder)
# Vomiting 2x/week (2), Eating Disorder present (1)
rome_iv_child_nausea_vomiting(0, 2, 0, 1, 0)
}
