\name{rome_iv_child_ibs}
\alias{rome_iv_child_ibs}
\title{
Rome IV Diagnostic Criteria for Child Irritable Bowel Syndrome (IBS)
}
\description{
Evaluates the Rome IV criteria for diagnosing Irritable Bowel Syndrome (IBS) in children and adolescents. Diagnosis requires abdominal pain at least 4 days per month associated with defecation or changes in stool, that cannot be fully explained by another medical condition or functional constipation.
}
\usage{
rome_iv_child_ibs(pain_frequency_days_month, related_to_defecation,
                  change_stool_frequency, change_stool_form,
                  pain_resolves_with_constipation_resolution,
                  medical_condition_explained)
}
\arguments{
  \item{pain_frequency_days_month}{
Numeric. Frequency of abdominal pain in days per month (must be >= 4).
}
  \item{related_to_defecation}{
Numeric (0 or 1). Is the pain related to defecation? (1 = Yes).
}
  \item{change_stool_frequency}{
Numeric (0 or 1). Is the pain associated with a change in frequency of stool? (1 = Yes).
}
  \item{change_stool_form}{
Numeric (0 or 1). Is the pain associated with a change in form (appearance) of stool? (1 = Yes).
}
  \item{pain_resolves_with_constipation_resolution}{
Numeric (0 or 1). In children with constipation, does the pain resolve with resolution of the constipation? (1 = Yes, this excludes IBS diagnosis in favor of functional constipation).
}
  \item{medical_condition_explained}{
Numeric (0 or 1). Can symptoms be fully explained by another medical condition? (1 = Yes).
}
}
\value{
A list containing:
\item{Diagnosis}{"Criteria Met for Irritable Bowel Syndrome (IBS)" or "Criteria Not Met".}
}
\references{
Hyams JS, Di Lorenzo C, Saps M, et al. Functional Disorders: Children and Adolescents. Gastroenterology. 2016;150:1456-1468. doi:10.1053/j.gastro.2016.02.015
}
\examples{

# Example 1: Criteria Met
# Pain 5 days/mo, related to defecation, not constipation-only, no other cause
rome_iv_child_ibs(5, 1, 0, 0, 0, 0)

# Example 2: Not Met (Pain resolves with constipation treatment)
# Pain 10 days/mo, change in form, but resolves when constipation fixed
rome_iv_child_ibs(10, 0, 0, 1, 1, 0)
}
