\name{rome_iv_child_functional_constipation}
\alias{rome_iv_child_functional_constipation}
\title{
Rome IV Diagnostic Criteria for Child Functional Constipation
}
\description{
Evaluates the **Rome IV criteria** for diagnosing **Functional Constipation** in children (4 years of age up to adolescence). Diagnosis requires the presence of at least **two** of the five specified symptoms for at least 1 month, and symptoms must not be attributable to an underlying medical condition. The presence of fecal incontinence determines the subtype.
}
\usage{
rome_iv_child_functional_constipation(stool_frequency_lt_3_week, hard_lumpy_stool,
                                       straining, large_diameter_stool,
                                       rectal_fecal_mass, fecal_incontinence_present,
                                       no_other_cause)
}
\arguments{
  \item{stool_frequency_lt_3_week}{
Numeric (0 or 1). **Two or fewer defecations** in the toilet per week. (1 = Yes).
}
  \item{hard_lumpy_stool}{
Numeric (0 or 1). History of passing **hard or lumpy stools** (Bristol Stool Form Scale 1-2)

[Image of bristol stool scale chart]
. (1 = Yes).
}
  \item{straining}{
Numeric (0 or 1). History of **straining** or holding back stools. (1 = Yes).
}
  \item{large_diameter_stool}{
Numeric (0 or 1). History of **large diameter stools** obstructing the toilet. (1 = Yes).
}
  \item{rectal_fecal_mass}{
Numeric (0 or 1). Presence of a **large fecal mass** in the rectum on examination. (1 = Yes).
}
  \item{fecal_incontinence_present}{
Numeric (0 or 1). Presence of **fecal incontinence** (at least 1 episode per week). (1 = Yes).
}
  \item{no_other_cause}{
Numeric (0 or 1). Have symptoms been active for at least 1 month and are NOT fully explained by another medical condition? (1 = Yes).
}
}
\value{
A list containing:
\item{Diagnosis}{The resulting classification (Functional Constipation or Functional Constipation with Fecal Incontinence).}
\item{Constipation_Criteria_Count}{The number of positive constipation criteria out of the five specified symptoms.}
}
\references{
Hyams JS, Di Lorenzo C, Saps M, et al. Functional Disorders: Children and Adolescents. Gastroenterology. 2016;150:1456-1468. doi:10.1053/j.gastro.2016.02.015
}
\examples{

# Example 1: Functional Constipation Only
# 2 stools/week (1), Hard stools (1), Straining (1), No incontinence, No other cause
# Score = 3 (Meets criteria for 2 or more)
rome_iv_child_functional_constipation(1, 1, 1, 0, 0, 0, 1)

# Example 2: Constipation with Incontinence
# Hard stools (1), Large stools (1), Fecal incontinence present (1), No other cause
# Score = 2 criteria + Incontinence present
rome_iv_child_functional_constipation(0, 1, 0, 1, 0, 1, 1)
}
