\name{rest_lgs_screen}
\alias{rest_lgs_screen}
\title{
Refractory Epilepsy Screening Tool for Lennox-Gastaut Syndrome (REST-LGS)
}
\description{
Applies the REST-LGS screening logic to identify patients with refractory epilepsy who may have undiagnosed Lennox-Gastaut Syndrome (LGS). The tool assesses four key domains: Age of onset, Drug resistance, Cognitive impairment, and Specific seizure types associated with LGS.
}
\usage{
rest_lgs_screen(onset_lt_9y, drug_resistant, cognitive_impairment,
                tonic_seizures, atonic_seizures, atypical_absence)
}
\arguments{
  \item{onset_lt_9y}{
Numeric (0 or 1). Did the patient's seizures start before age 9? (1 = Yes).
}
  \item{drug_resistant}{
Numeric (0 or 1). Is the epilepsy drug-resistant (failed >= 2 anti-seizure medications)? (1 = Yes).
}
  \item{cognitive_impairment}{
Numeric (0 or 1). Does the patient have cognitive impairment or developmental delay? (1 = Yes).
}
  \item{tonic_seizures}{
Numeric (0 or 1). History or presence of tonic seizures (stiffening). (1 = Yes).
}
  \item{atonic_seizures}{
Numeric (0 or 1). History or presence of atonic seizures (drop attacks/head drops). (1 = Yes).
}
  \item{atypical_absence}{
Numeric (0 or 1). History or presence of atypical absence seizures (staring spells). (1 = Yes).
}
}
\value{
A list containing:
\item{Screening_Result}{"Positive Screen" or "Negative Screen".}
\item{Recommendation}{Clinical guidance based on the screening result.}
}
\references{
Piña-Garza JE, Montouris GD, Spearman BK, et al. The Refractory Epilepsy Screening Tool for Lennox-Gastaut Syndrome (REST-LGS). Epilepsy Behav. 2019;90:148-153. doi:10.1016/j.yebeh.2018.11.016
}
\examples{

# Example 1: Positive Screen
# Onset <9, Resistant, Cognitive issues, Tonic seizures
rest_lgs_screen(1, 1, 1, 1, 0, 0)

# Example 2: Negative Screen
# Onset >9 years old
rest_lgs_screen(0, 1, 1, 1, 0, 0)
}
