\name{preset_ecmo_score}
\alias{preset_ecmo_score}
\title{
PRESET Score for Survival on ECMO
}
\description{
Calculates the PREdiction of Survival on ECMO Therapy (PRESET) Score. This tool predicts in-hospital survival for adult patients placed on venovenous extracorporeal membrane oxygenation (VV-ECMO) for severe acute respiratory failure. It stratifies patients into three risk classes based on admission physiology and pre-ECMO hospital duration.
}
\usage{
preset_ecmo_score(mean_arterial_pressure, lactate, arterial_ph,
                  platelet_count, hospital_days_pre_ecmo)
}
\arguments{
  \item{mean_arterial_pressure}{
Numeric. Mean Arterial Pressure (MAP) in mmHg.
>100: 0 pts
91-100: 1 pt
81-90: 2 pts
71-80: 3 pts
<=70: 4 pts
}
  \item{lactate}{
Numeric. Serum lactate concentration in mmol/L.
<=1.5: 0 pts
1.51-3.0: 1 pt
3.01-6.0: 2 pts
6.01-10.0: 3 pts
>10.0: 4 pts
}
  \item{arterial_ph}{
Numeric. Arterial pH (pHa).
>7.30: 0 pts
7.201-7.30: 1 pt
7.101-7.20: 2 pts
<=7.10: 3 pts
}
  \item{platelet_count}{
Numeric. Platelet count in x10^3/uL (or x10^9/L).
>200: 0 pts
101-200: 1 pt
<=100: 2 pts
}
  \item{hospital_days_pre_ecmo}{
Numeric. Number of days in the hospital before ECMO initiation.
<=2: 0 pts
3-7: 1 pt
>7: 2 pts
}
}
\value{
A list containing:
\item{PRESET_Score}{The calculated score (Range 0-15).}
\item{Risk_Class}{Risk classification (Class I: 0-3, Class II: 4-5, Class III: >=6).}
\item{Est_Hospital_Survival}{Estimated probability of survival to hospital discharge.}
}
\references{
Hilder M, Herbstreit F, Adamzik M, et al. Comparison of mortality prediction models in acute respiratory distress syndrome undergoing extracorporeal membrane oxygenation and development of a novel prediction score: the PREdiction of Survival on ECMO Therapy-Score (PRESET-Score). Crit Care. 2017;21(1):301. doi:10.1186/s13054-017-1888-6
}
\examples{

# Example 1: Good Prognosis (Class I)
# MAP 95, Lactate 1.2, pH 7.35, Plt 250, Day 1
# Score = 1 + 0 + 0 + 0 + 0 = 1
preset_ecmo_score(95, 1.2, 7.35, 250, 1)

# Example 2: Poor Prognosis (Class III)
# MAP 65, Lactate 8.0, pH 7.15, Plt 80, Day 8
# Score = 4 + 3 + 2 + 2 + 2 = 13
preset_ecmo_score(65, 8.0, 7.15, 80, 8)
}
