\name{plan_stroke_score}
\alias{plan_stroke_score}
\title{
PLAN Score for Stroke
}
\description{
Calculates the PLAN score to predict 30-day and 1-year mortality, as well as severe disability (mRS 5-6) at discharge, for patients with acute ischemic stroke. The score uses clinical variables including Preadmission comorbidities, Level of consciousness, Age, and Neurologic deficit.
}
\usage{
plan_stroke_score(age, preadmission_dependence, cancer, congestive_heart_failure,
                  atrial_fibrillation, reduced_consciousness, arm_weakness,
                  leg_weakness, aphasia_neglect)
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
61-70: 2 pts.
71-80: 5 pts.
81-90: 7 pts.
>90: 9 pts.
}
  \item{preadmission_dependence}{
Numeric (0 or 1). Preadmission dependence (e.g., Rankin score >= 3) requiring assistance for ADLs. (1 = Yes, +1.5 pts).
}
  \item{cancer}{
Numeric (0 or 1). History of cancer (excluding non-melanoma skin cancer). (1 = Yes, +1.5 pts).
}
  \item{congestive_heart_failure}{
Numeric (0 or 1). History of congestive heart failure. (1 = Yes, +1 pt).
}
  \item{atrial_fibrillation}{
Numeric (0 or 1). History of atrial fibrillation. (1 = Yes, +1 pt).
}
  \item{reduced_consciousness}{
Numeric (0 or 1). Reduced level of consciousness on admission (not fully alert). (1 = Yes, +5 pts).
}
  \item{arm_weakness}{
Numeric (0 or 1). Significant or total arm weakness. (1 = Yes, +2 pts).
}
  \item{leg_weakness}{
Numeric (0 or 1). Significant or total leg weakness. (1 = Yes, +2 pts).
}
  \item{aphasia_neglect}{
Numeric (0 or 1). Presence of aphasia or neglect. (1 = Yes, +1 pt).
}
}
\value{
A list containing:
\item{PLAN_Score}{The calculated total risk score.}
\item{Est_30_Day_Mortality}{Estimated 30-day mortality percentage.}
\item{Est_1_Year_Mortality}{Estimated 1-year mortality percentage.}
\item{Poor_Outcome_Discharge_mRS_5_6}{Estimated percentage of patients with mRS 5-6 (severe disability or death) at discharge.}
}
\references{
O'Donnell MJ, Fang J, D'Uva C, et al. The PLAN score: a bedside prediction rule for death and severe disability following acute ischemic stroke. Arch Intern Med. 2012;172(20):1548-1556. doi:10.1001/2013.jamainternmed.30
}
\examples{

# Example 1: Low Risk
# 55yo, No comorbidities, Alert, Mild Arm Weakness (not significant)
# Score = 0
plan_stroke_score(55, 0, 0, 0, 0, 0, 0, 0, 0)

# Example 2: High Risk
# 85yo (+7), AF (+1), Reduced LOC (+5), Total Arm/Leg Weakness (+4)
# Score = 17
plan_stroke_score(85, 0, 0, 0, 1, 1, 1, 1, 0)
}
