\name{pedsrc_bat_rule}
\alias{pedsrc_bat_rule}
\title{
PedSRC Rule for Pediatric Blunt Abdominal Trauma
}
\description{
Calculates the risk stratification for Intra-abdominal Injury (IAI) in pediatric patients with blunt abdominal trauma, based on the Pediatric Surgery Research Collaborative (PedSRC) guidelines. The rule identifies patients at very low risk for IAI who may safely avoid abdominal CT scans.
}
\usage{
pedsrc_bat_rule(abdominal_tenderness, abdominal_wall_trauma, gcs_score, ast, alt,
                urinalysis_hematuria_gt_5_rbc, abnormal_xray = 0)
}
\arguments{
  \item{abdominal_tenderness}{
Numeric (0 or 1). Presence of abdominal tenderness on physical examination. (1 = Yes).
}
  \item{abdominal_wall_trauma}{
Numeric (0 or 1). Evidence of abdominal wall trauma, such as bruising or a seatbelt sign. (1 = Yes).
}
  \item{gcs_score}{
Numeric. Glasgow Coma Scale score. (GCS < 14 is a risk factor).
}
  \item{ast}{
Numeric. Aspartate Aminotransferase level in U/L. (> 200 U/L is a risk factor).
}
  \item{alt}{
Numeric. Alanine Aminotransferase level in U/L. (> 125 U/L is a risk factor).
}
  \item{urinalysis_hematuria_gt_5_rbc}{
Numeric (0 or 1). Presence of microscopic hematuria (> 5 RBC/hpf) on urinalysis. (1 = Yes).
}
  \item{abnormal_xray}{
Numeric (0 or 1). Presence of abnormal findings on chest or pelvic X-ray (e.g., rib/pelvic fracture), if performed. (1 = Yes, 0 = No/Not Performed).
}
}
\value{
A list containing:
\item{Risk_Classification}{"Very Low Risk" if no criteria are met, otherwise "Not Low Risk".}
\item{Recommendation}{Clinical guidance regarding the need for CT imaging.}
\item{Criteria_Present}{List of positive risk factors identified.}
}
\references{
Streck CJ, Vogel AM, Zhang J, et al. Pediatrics Surgery Research Collaborative (PedSRC). Derivation and validation of a clinical prediction rule for pediatric blunt abdominal trauma.
}
\examples{

# Example 1: Low Risk
# No tenderness, no trauma sign, GCS 15, normal labs
pedsrc_bat_rule(0, 0, 15, 40, 35, 0, 0)

# Example 2: High Risk
# Seatbelt sign present (1), AST 250, Hematuria present (1)
pedsrc_bat_rule(0, 1, 15, 250, 40, 1, 0)
}
