\name{pediatric_appendicitis_score}
\alias{pediatric_appendicitis_score}
\title{
Pediatric Appendicitis Score (PAS)
}
\description{
Calculates the Pediatric Appendicitis Score (PAS), also known as the Samuel Score, to stratify the risk of acute appendicitis in children presenting with abdominal pain. The score ranges from 0 to 10 and categorizes patients into low, intermediate, or high risk groups.
}
\usage{
pediatric_appendicitis_score(cough_hop_pain, anorexia, temperature_c,
                             nausea_vomiting, rlq_tenderness, wbc_count,
                             neutrophil_percent, migration_of_pain)
}
\arguments{
  \item{cough_hop_pain}{
Numeric (0 or 1). Presence of cough, percussion, or hopping tenderness in the right lower quadrant. (1 = Yes, +2 points).
}
  \item{anorexia}{
Numeric (0 or 1). Presence of anorexia. (1 = Yes, +1 point).
}
  \item{temperature_c}{
Numeric. Patient's body temperature in degrees Celsius. (> 38.0 C adds +1 point).
}
  \item{nausea_vomiting}{
Numeric (0 or 1). Presence of nausea or vomiting. (1 = Yes, +1 point).
}
  \item{rlq_tenderness}{
Numeric (0 or 1). Tenderness over the right iliac fossa (RLQ). (1 = Yes, +2 points).
}
  \item{wbc_count}{
Numeric. White blood cell count in cells/uL (e.g., 12000). (> 10,000 adds +1 point).
}
  \item{neutrophil_percent}{
Numeric. Percentage of neutrophils (polymorphonuclear neutrophilia). (> 75\% adds +1 point).
}
  \item{migration_of_pain}{
Numeric (0 or 1). Migration of pain to the right lower quadrant (RLQ). (1 = Yes, +1 point).
}
}
\value{
A list containing:
\item{PAS_Score}{The calculated total score (Range 0-10).}
\item{Risk_Category}{Risk stratification (Low, Intermediate, High).}
\item{Recommendation}{Clinical guidance based on the score.}
}
\references{
Samuel M. Pediatric appendicitis score. J Pediatr Surg. 2002;37(6):877-881. doi:10.1053/jpsu.2002.32893
}
\examples{

# Example 1: High Risk
# Cough pain, RLQ tenderness, WBC 15k, Neutrophils 80%, Migration, Anorexia
# Score = 2 + 2 + 1 + 1 + 1 + 1 = 8
pediatric_appendicitis_score(1, 1, 37.5, 0, 1, 15000, 80, 1)

# Example 2: Low Risk
# Nausea only, normal labs
# Score = 1
pediatric_appendicitis_score(0, 0, 37.0, 1, 0, 8000, 50, 0)
}
