\name{patient_activity_scale_ii}
\alias{patient_activity_scale_ii}
\title{
Patient Activity Scale-II (PAS-II) for Rheumatoid Arthritis
}
\description{
Calculates the Patient Activity Scale-II (PAS-II), a patient-reported outcome measure for Rheumatoid Arthritis disease activity. It combines Pain VAS, Patient Global Assessment VAS, and the HAQ-II functional score into a single 0-10 scale.
}
\usage{
patient_activity_scale_ii(pain_vas, patient_global_vas, haq_ii_items)
}
\arguments{
  \item{pain_vas}{
Numeric (0-10). Patient's assessment of pain on a 10 cm visual analog scale.
}
  \item{patient_global_vas}{
Numeric (0-10). Patient's global assessment of disease activity on a 10 cm visual analog scale.
}
  \item{haq_ii_items}{
Numeric vector of length 10. Scores for the 10 HAQ-II items (0=No difficulty, 1=Some difficulty, 2=Much difficulty, 3=Unable to do).
Items cover: Standing up, Walking outdoors, Walking up steps, Washing, Reaching, Opening car door, Yard work, Waiting in line, Lifting heavy objects, Moving heavy objects.
}
}
\value{
A list containing:
\item{PAS_II_Score}{The calculated score (Range 0-10).}
\item{Disease_Activity}{Classification (Remission <= 0.25, Low <= 3.7, Moderate < 8.0, High >= 8.0).}
\item{Components}{The individual weighted components used in the calculation.}
}
\references{
Anderson J, Caplan L, Yazdany J, et al. Rheumatoid arthritis disease activity measures: American College of Rheumatology recommendations for use in clinical practice. Arthritis Care Res (Hoboken). 2012;64(5):640-647. doi:10.1002/acr.21649
}
\examples{

# Example 1: High Activity
# Pain 8, Global 9, HAQ-II mixed difficulty
haq_high <- c(2, 2, 3, 1, 3, 2, 3, 1, 3, 2)
patient_activity_scale_ii(8, 9, haq_high)

# Example 2: Low Activity
# Pain 2, Global 1, HAQ-II no difficulty
haq_low <- rep(0, 10)
patient_activity_scale_ii(2, 1, haq_low)
}
