\name{pack_years_calculator}
\alias{pack_years_calculator}
\title{
Pack Years Calculator
}
\description{
Calculates the number of pack-years, a standard measure of cumulative cigarette smoking exposure. One pack-year is defined as smoking 20 cigarettes (one pack) per day for one year.
}
\usage{
pack_years_calculator(packs_per_day = NULL, cigarettes_per_day = NULL, years_smoked)
}
\arguments{
  \item{packs_per_day}{
Numeric. The number of packs of cigarettes smoked per day. (Optional if cigarettes_per_day is provided).
}
  \item{cigarettes_per_day}{
Numeric. The number of individual cigarettes smoked per day. (Optional if packs_per_day is provided).
}
  \item{years_smoked}{
Numeric. The total number of years the patient has smoked.
}
}
\details{
Formula:
\deqn{Pack Years = \frac{Cigarettes Per Day}{20} \times Years Smoked}
OR
\deqn{Pack Years = Packs Per Day \times Years Smoked}
}
\value{
A list containing:
\item{Pack_Years}{The calculated pack-years value.}
}
\references{
Bernhardt PW, et al. Pack-years of smoking as a predictor of lung cancer.
}
\examples{

# Example 1: Using packs per day
# 1.5 packs/day for 20 years
pack_years_calculator(packs_per_day = 1.5, years_smoked = 20)

# Example 2: Using cigarettes per day
# 10 cigarettes/day for 15 years
# 10/20 = 0.5 packs * 15 years = 7.5 pack-years
pack_years_calculator(cigarettes_per_day = 10, years_smoked = 15)
}
