\name{nri_score}
\alias{nri_score}
\title{
Nutritional Risk Index (NRI)
}
\description{
Calculates the Nutritional Risk Index (NRI) to assess the extent of malnutrition in patients, particularly in surgical or elderly populations. The score uses serum albumin levels and the ratio of current to usual body weight to stratify patients into risk categories.
}
\usage{
nri_score(albumin_g_dl, current_weight_kg, usual_weight_kg)
}
\arguments{
  \item{albumin_g_dl}{
Numeric. Serum Albumin level in g/dL. Note: The formula converts this to g/L internally.
}
  \item{current_weight_kg}{
Numeric. The patient's current weight in kilograms.
}
  \item{usual_weight_kg}{
Numeric. The patient's usual or baseline weight in kilograms.
}
}
\details{
The formula used is:
\deqn{NRI = (1.519 \times Albumin_{g/L}) + 41.7 \times \frac{Current Weight}{Usual Weight}}
Note: If Current Weight exceeds Usual Weight, the weight ratio is set to 1 to avoid overestimating nutritional status in obese patients with hypoalbuminemia.
}
\value{
A list containing:
\item{NRI_Score}{The calculated index value.}
\item{Risk_Category}{Clinical interpretation of the score (> 100: No Risk, 97.5 - 100: Mild Risk, 83.5 - <97.5: Moderate Risk, < 83.5: Severe Risk).}
}
\references{
Buzby GP, et al. Prognostic nutritional index in gastrointestinal surgery. Am J Surg. 1980;139(1):160-167. doi:10.1016/0002-9610(80)90246-9
Veterans Affairs Total Parenteral Nutrition Cooperative Study Group. Perioperative total parenteral nutrition in surgical patients. N Engl J Med. 1991;325(8):525-532. doi:10.1056/NEJM199108223250801
}
\examples{

# Example 1: Normal Status
# Albumin 4.5 g/dL (45 g/L), Weight stable (Ratio 1)
# Score = (1.519 * 45) + 41.7 = 68.355 + 41.7 = 110.1
nri_score(4.5, 70, 70)

# Example 2: Severe Risk
# Albumin 2.5 g/dL (25 g/L), Significant weight loss (55/70 = 0.785)
# Score = (1.519 * 25) + (41.7 * 0.785) = 37.975 + 32.73 = 70.7
nri_score(2.5, 55, 70)
}
