\name{myxedema_coma_score}
\alias{myxedema_coma_score}
\title{
Myxedema Coma Diagnostic Score
}
\description{
Calculates the diagnostic score for myxedema coma. This tool aggregates clinical and laboratory findings (thermoregulation, CNS status, GI symptoms, cardiovascular dysfunction, metabolic disturbances, and precipitating events) to assess the likelihood of myxedema coma in patients with severe hypothyroidism.
}
\usage{
myxedema_coma_score(temp_c, cns_status, gi_symptoms, precipitating_event,
                    bradycardia, ecg_changes, hypotension, hyponatremia,
                    hypoglycemia, hypoxemia_hypercapnia)
}
\arguments{
  \item{temp_c}{
Numeric. Body temperature in degrees Celsius. (>35: 0 pts, 32-35: 10 pts, <32: 20 pts).
}
  \item{cns_status}{
String. Central Nervous System status. Options: "absent" (0 pts), "drowsy_lethargic" (10 pts), "obtunded" (15 pts), "stupor_coma" (20 pts).
}
  \item{gi_symptoms}{
String. Gastrointestinal symptoms. Options: "absent" (0 pts), "anorexia_pain_constipation" (5 pts), "decreased_motility_ileus" (10 pts).
}
  \item{precipitating_event}{
Numeric (0 or 1). Presence of a precipitating event (e.g., infection, surgery, drug exposure). (1 = Yes, +10 pts).
}
  \item{bradycardia}{
Numeric (0 or 1). Bradycardia present. (1 = Yes, +10 pts).
}
  \item{ecg_changes}{
Numeric (0 or 1). ECG changes present (e.g., low voltage, prolonged QT, heart block). (1 = Yes, +10 pts).
}
  \item{hypotension}{
Numeric (0 or 1). Hypotension or cardiogenic shock present. (1 = Yes, +10 pts).
}
  \item{hyponatremia}{
Numeric (0 or 1). Hyponatremia present. (1 = Yes, +10 pts).
}
  \item{hypoglycemia}{
Numeric (0 or 1). Hypoglycemia present. (1 = Yes, +10 pts).
}
  \item{hypoxemia_hypercapnia}{
Numeric (0 or 1). Hypoxemia or hypercapnia present. (1 = Yes, +10 pts).
}
}
\value{
A list containing:
\item{Diagnostic_Score}{The calculated total score.}
\item{Interpretation}{Diagnostic likelihood (Unlikely <25, Suggestive 25-59, Diagnostic >=60).}
}
\references{
Popoveniuc G, Chandra T, Sud A, et al. A diagnostic scoring system for myxedema coma. Endocr Pract. 2014;20(8):808-817. doi:10.4158/EP13303.OR
}
\examples{

# Example 1: Diagnostic (Score 70)
# Temp 30C (20), Coma (20), Ileus (10), Precipitant (10), Bradycardia (10)
myxedema_coma_score(30, "stupor_coma", "decreased_motility_ileus", 1, 1, 0, 0, 0, 0, 0)

# Example 2: Suggestive (Score 30)
# Temp 34C (10), Lethargic (10), Hypoglycemia (10)
myxedema_coma_score(34, "drowsy_lethargic", "absent", 0, 0, 0, 0, 0, 1, 0)
}
