\name{multiple_myeloma_response_criteria}
\alias{multiple_myeloma_response_criteria}
\title{
IMWG Multiple Myeloma Response Criteria
}
\description{
Evaluates the response to treatment in patients with Multiple Myeloma according to the International Myeloma Working Group (IMWG) uniform response criteria. Classification ranges from Progressive Disease (PD) to Stringent Complete Response (sCR) based on changes in M-protein (serum/urine), FLC levels, bone marrow plasma cells, and imaging findings relative to baseline or nadir.
}
\usage{
multiple_myeloma_response_criteria(serum_m_baseline, serum_m_nadir, serum_m_current,
                                   urine_m_baseline, urine_m_nadir, urine_m_current,
                                   flc_diff_baseline, flc_diff_nadir, flc_diff_current,
                                   bone_marrow_pct, immunofixation_status, flc_ratio,
                                   plasmacytoma_status, bone_lesions_new_increased,
                                   hypercalcemia_present)
}
\arguments{
  \item{serum_m_baseline}{Numeric. Baseline Serum M-protein (g/dL).}
  \item{serum_m_nadir}{Numeric. Lowest recorded Serum M-protein (g/dL). Used for PD assessment.}
  \item{serum_m_current}{Numeric. Current Serum M-protein (g/dL).}
  \item{urine_m_baseline}{Numeric. Baseline Urine M-protein (mg/24h).}
  \item{urine_m_nadir}{Numeric. Lowest recorded Urine M-protein (mg/24h).}
  \item{urine_m_current}{Numeric. Current Urine M-protein (mg/24h).}
  \item{flc_diff_baseline}{Numeric. Baseline difference between involved and uninvolved FLC (mg/dL).}
  \item{flc_diff_nadir}{Numeric. Lowest recorded FLC difference (mg/dL).}
  \item{flc_diff_current}{Numeric. Current FLC difference (mg/dL).}
  \item{bone_marrow_pct}{Numeric. Current percentage of bone marrow plasma cells.}
  \item{immunofixation_status}{String. Result of serum/urine immunofixation. Options: "positive", "negative".}
  \item{flc_ratio}{Numeric. Current Kappa/Lambda FLC ratio. (Normal range approx 0.26-1.65 used for sCR).}
  \item{plasmacytoma_status}{String. Status of soft tissue plasmacytomas. Options: "none", "stable", "decreased_50" (>=50\% decrease), "disappeared", "increased", "new".}
  \item{bone_lesions_new_increased}{Numeric (0 or 1). Development of new or increased size of lytic bone lesions. (1 = Yes).}
  \item{hypercalcemia_present}{Numeric (0 or 1). Development of hypercalcemia (>11.5 mg/dL) attributable to plasma cell proliferative disorder. (1 = Yes).}
}
\value{
A list containing:
\item{Response_Category}{The determined response status (sCR, CR, VGPR, PR, SD, or PD).}
\item{Inputs}{Structured list of input values used for calculation.}
}
\references{
Kumar S, Paiva B, Anderson KC, et al. International Myeloma Working Group consensus criteria for response and minimal residual disease assessment in multiple myeloma. Lancet Oncol. 2016;17(8):e328-e346. doi:10.1016/S1470-2045(16)30206-6
}
\examples{
# Example 1: Partial Response
# Baseline M=4.0, Current M=1.5 (Reduc >50\%), IFE Positive
multiple_myeloma_response_criteria(4.0, 1.0, 1.5, 0, 0, 0, 0, 0,
0, 8, "positive", 2.0, "none", 0, 0)

# Example 2: Progressive Disease
# Nadir M=1.0, Current M=2.0 (Increase >0.5g/dL and >25\%)
multiple_myeloma_response_criteria(4.0, 1.0, 2.0, 0, 0, 0, 0, 0,
0, 10, "positive", 2.0, "none", 0, 0)
}
