\name{mrs_9q_score}
\alias{mrs_9q_score}
\title{
Modified Rankin Scale (mRS-9Q) Calculator
}
\description{
Calculates the Modified Rankin Scale (mRS) score using the 9-question (mRS-9Q) logic. This tool determines the degree of disability in stroke patients by asking a hierarchical series of yes/no questions regarding functional independence.
}
\usage{
mrs_9q_score(symptoms_present, able_usual_activities, able_own_affairs,
             able_walk_unassisted, able_bodily_needs)
}
\arguments{
  \item{symptoms_present}{
Numeric (0 or 1). Does the patient have any symptoms? (1 = Yes).
}
  \item{able_usual_activities}{
Numeric (0 or 1). Is the patient able to carry out all usual duties and activities? (1 = Yes).
}
  \item{able_own_affairs}{
Numeric (0 or 1). Is the patient able to look after their own affairs without assistance? (1 = Yes).
}
  \item{able_walk_unassisted}{
Numeric (0 or 1). Is the patient able to walk without assistance? (1 = Yes).
}
  \item{able_bodily_needs}{
Numeric (0 or 1). Is the patient able to attend to their own bodily needs without assistance? (1 = Yes).
}
}
\value{
A list containing:
\item{mRS_Score}{The calculated mRS score (Range 0-5).}
\item{Description}{Clinical description of the disability level.}
}
\references{
Bruno A, Akinwuntan AE, Lin C, et al. Simplified modified rankin scale questionnaire: reproducibility over the telephone and validation with quality of life. Stroke. 2011;42(8):2276-2279. doi:10.1161/STROKEAHA.111.613273
}
\examples{

# Example 1: Slight Disability (mRS 2)
# Symptoms(1), Can't do usual(0), But handles affairs(1)
mrs_9q_score(1, 0, 1, 1, 1)

# Example 2: Severe Disability (mRS 5)
# Symptoms(1), No activities(0), No affairs(0), No walk(0), No bodily care(0)
mrs_9q_score(1, 0, 0, 0, 0)
}
