\name{modified_sgarbossa_criteria}
\alias{modified_sgarbossa_criteria}
\title{
Modified Sgarbossa Criteria for MI with LBBB
}
\description{
Evaluates the Modified Sgarbossa Criteria to diagnose Acute Myocardial Infarction (AMI) in the presence of Left Bundle Branch Block (LBBB) or Ventricular Paced Rhythm. This modification improves sensitivity over the original criteria by using a proportional ratio (ST/S ratio) for discordant ST elevation rather than an absolute cutoff.
}
\usage{
modified_sgarbossa_criteria(st_elevation_concordant_mm, st_depression_v1_v3_mm,
                            st_elevation_discordant_mm, s_wave_amplitude_mm)
}
\arguments{
  \item{st_elevation_concordant_mm}{
Numeric. Magnitude of ST elevation (mm) in leads with a positive QRS complex (Concordant STE). (Criterion: >= 1 mm).
}
  \item{st_depression_v1_v3_mm}{
Numeric. Magnitude of ST depression (mm) in leads V1, V2, or V3 (Concordant STD). (Criterion: >= 1 mm).
}
  \item{st_elevation_discordant_mm}{
Numeric. Magnitude of ST elevation (mm) in leads with a negative QRS complex (Discordant STE). Used for ratio calculation.
}
  \item{s_wave_amplitude_mm}{
Numeric. Magnitude (depth) of the S-wave (mm) in the same lead as the discordant STE. Used for ratio calculation.
}
}
\value{
A list containing:
\item{Result}{Diagnostic interpretation ("Positive" or "Negative").}
\item{Criteria_Met}{List of specific criteria satisfied.}
\item{Calculated_Ratio}{The calculated ST/S ratio.}
}
\references{
Smith SW, Dodd KW, Henry TD, Dvorak DM, Pearce LA. Diagnosis of ST-elevation myocardial infarction in the presence of left bundle branch block with the ST-elevation to S-wave ratio in a modified Sgarbossa rule. Ann Emerg Med. 2012;60(6):766-776. doi:10.1016/j.annemergmed.2012.07.119
}
\examples{

# Example 1: Positive (Concordant STE)
# STE Conc 2mm, STD V1-V3 0, STE Disc 0, S-wave 10
modified_sgarbossa_criteria(2, 0, 0, 10)

# Example 2: Positive (Modified Ratio)
# STE Conc 0, STD 0, STE Disc 4mm, S-wave 10mm (Ratio 0.4)
modified_sgarbossa_criteria(0, 0, 4, 10)

# Example 3: Negative
# STE Conc 0, STD 0, STE Disc 2mm, S-wave 20mm (Ratio 0.1)
modified_sgarbossa_criteria(0, 0, 2, 20)
}
