\name{modified_rankin_scale}
\alias{modified_rankin_scale}
\title{
Modified Rankin Scale (mRS)
}
\description{
Retrieves the clinical description for the Modified Rankin Scale (mRS) score. The mRS is a widely used scale for measuring the degree of disability or dependence in the daily activities of people who have suffered a stroke or other neurological disability.
}
\usage{
modified_rankin_scale(score)
}
\arguments{
  \item{score}{
Numeric. The mRS score (0-6).
0: No symptoms.
1: No significant disability.
2: Slight disability.
3: Moderate disability.
4: Moderately severe disability.
5: Severe disability.
6: Dead.
}
}
\value{
A list containing:
\item{mRS_Score}{The input score.}
\item{Description}{The clinical definition associated with the score.}
}
\references{
Rankin J. Cerebral vascular accidents in patients over the age of 60. II. Prognosis. Scott Med J. 1957;2(5):200-215.
van Swieten JC, Koudstaal PJ, Visser MC, Schouten HJ, van Gijn J. Interobserver agreement for the assessment of handicap in stroke patients. Stroke. 1988;19(5):604-607.
}
\examples{

# Example 1: Slight Disability
modified_rankin_scale(2)

# Example 2: Severe Disability
modified_rankin_scale(5)
}
