\name{modified_hoehn_yahr_scale}
\alias{modified_hoehn_yahr_scale}
\title{
Modified Hoehn and Yahr Scale for Parkinson's Disease
}
\description{
Retrieves the clinical description for the Modified Hoehn and Yahr Scale. This system stages the severity of Parkinson's disease based on clinical findings regarding unilateral versus bilateral involvement and the preservation of postural reflexes.
}
\usage{
modified_hoehn_yahr_scale(stage)
}
\arguments{
  \item{stage}{
Numeric. The assessed stage of the patient.
1.0: Unilateral involvement only.
1.5: Unilateral and axial involvement.
2.0: Bilateral involvement without impairment of balance.
2.5: Mild bilateral disease with recovery on pull test.
3.0: Mild to moderate bilateral disease; some postural instability; physically independent.
4.0: Severe disability; still able to walk or stand unassisted.
5.0: Wheelchair bound or bedridden unless aided.
}
}
\value{
A list containing:
\item{Hoehn_Yahr_Stage}{The input stage.}
\item{Description}{The clinical definition associated with the stage.}
}
\references{
Goetz CG, Poewe W, Rascol O, et al. Movement Disorder Society Task Force report on the Hoehn and Yahr staging scale: status and recommendations. Mov Disord. 2004;19(9):1020-1028. doi:10.1002/mds.20213
Hoehn MM, Yahr MD. Parkinsonism: onset, progression and mortality. Neurology. 1967;17(5):427-442.
}
\examples{

# Example 1: Stage 2.5 (Mild Bilateral)
modified_hoehn_yahr_scale(2.5)

# Example 2: Stage 5 (Severe)
modified_hoehn_yahr_scale(5)
}
