\name{modified_fatigue_impact_scale}
\alias{modified_fatigue_impact_scale}
\title{
Modified Fatigue Impact Scale (MFIS)
}
\description{
Calculates the Modified Fatigue Impact Scale (MFIS) score, a 21-item assessment derived from the Fatigue Impact Scale. It evaluates the effects of fatigue on physical, cognitive, and psychosocial functioning in patients with Multiple Sclerosis (MS).
}
\usage{
modified_fatigue_impact_scale(q1, q2, q3, q4, q5, q6, q7, q8, q9, q10,
                              q11, q12, q13, q14, q15, q16, q17, q18,
                              q19, q20, q21)
}
\arguments{
  \item{q1}{Numeric (0-4). I have been less alert.}
  \item{q2}{Numeric (0-4). I have had difficulty paying attention for long periods of time.}
  \item{q3}{Numeric (0-4). I have been unable to think clearly.}
  \item{q4}{Numeric (0-4). I have been clumsy and uncoordinated.}
  \item{q5}{Numeric (0-4). I have been forgetful.}
  \item{q6}{Numeric (0-4). I have had to pace myself in my physical activities.}
  \item{q7}{Numeric (0-4). I have been less motivated to do anything that requires physical effort.}
  \item{q8}{Numeric (0-4). I have been less motivated to participate in social activities.}
  \item{q9}{Numeric (0-4). I have been limited in my ability to do things away from home.}
  \item{q10}{Numeric (0-4). I have had trouble maintaining physical effort for long periods.}
  \item{q11}{Numeric (0-4). I have had difficulty making decisions.}
  \item{q12}{Numeric (0-4). I have been less motivated to do anything that requires thinking.}
  \item{q13}{Numeric (0-4). My muscles have felt weak.}
  \item{q14}{Numeric (0-4). I have been physically uncomfortable.}
  \item{q15}{Numeric (0-4). I have had trouble finishing tasks that require thinking.}
  \item{q16}{Numeric (0-4). I have had difficulty organizing my thoughts when doing things at home or work.}
  \item{q17}{Numeric (0-4). I have been less able to complete tasks that require physical effort.}
  \item{q18}{Numeric (0-4). My thinking has been slowed down.}
  \item{q19}{Numeric (0-4). I have had trouble concentrating.}
  \item{q20}{Numeric (0-4). I have limited my physical activities.}
  \item{q21}{Numeric (0-4). I have needed to rest more often or for longer periods.}
}
\details{
\strong{Scoring Key:}
0 = Never
1 = Rarely
2 = Sometimes
3 = Often
4 = Almost always

\strong{Subscales:}
Physical: Q4, 6, 7, 10, 13, 14, 17, 20, 21 (Range 0-36)
Cognitive: Q1, 2, 3, 5, 11, 12, 15, 16, 18, 19 (Range 0-40)
Psychosocial: Q8, 9 (Range 0-8)
}
\value{
A list containing:
\item{MFIS_Total_Score}{The calculated total score (Range 0-84).}
\item{Impact_Interpretation}{Classification based on the cutoff of 38 (predictive of clinically significant fatigue).}
\item{Subscales}{A list containing the Physical, Cognitive, and Psychosocial domain scores.}
}
\references{
Multiple Sclerosis Council for Clinical Practice Guidelines. Fatigue and Multiple Sclerosis: Evidence-Based Management Strategies for Fatigue in Multiple Sclerosis. Washington, DC: Paralyzed Veterans of America; 1998.
}
\examples{

# Example 1: High Impact
# All items scored 3
modified_fatigue_impact_scale(3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
                              3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3)

# Example 2: Low Impact
# All items scored 1
modified_fatigue_impact_scale(1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                              1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1)
}
