\name{michigan_picc_risk_score}
\alias{michigan_picc_risk_score}
\title{
Michigan Risk Score for PICC-Related Thrombosis
}
\description{
Calculates the Michigan Risk Score to estimate the probability of symptomatic deep vein thrombosis (DVT) associated with the placement of a Peripherally Inserted Central Catheter (PICC). The score stratifies patients into four risk classes based on five clinical variables.
}
\usage{
michigan_picc_risk_score(history_thrombosis, multilumen_catheter, active_cancer,
                         another_cvc_present, wbc_gt_12000)
}
\arguments{
  \item{history_thrombosis}{
Numeric (0 or 1). History of Deep Vein Thrombosis (DVT). (1 = Yes, +2 points).
}
  \item{multilumen_catheter}{
Numeric (0 or 1). Is the PICC multi-lumen (2 or more lumens)? (1 = Yes, +1 point).
}
  \item{active_cancer}{
Numeric (0 or 1). Active cancer (treated within the last 6 months). (1 = Yes, +3 points).
}
  \item{another_cvc_present}{
Numeric (0 or 1). Is another Central Venous Catheter (CVC) present at the time of placement? (1 = Yes, +1 point).
}
  \item{wbc_gt_12000}{
Numeric (0 or 1). White Blood Cell count > 12,000 cells/mm^3 at the time of placement? (1 = Yes, +1 point).
}
}
\value{
A list containing:
\item{MRS_Score}{The calculated total score (Range 0-8).}
\item{Risk_Class}{Classification (Class I: 0, Class II: 1-2, Class III: 3, Class IV: >=4).}
\item{Est_Thrombosis_Risk}{Estimated percentage risk of PICC-related thrombosis.}
}
\references{
Chopra V, Flanders SA, Saint S, et al. The Michigan Risk Score to predict peripherally inserted central catheter-associated thrombosis. J Thromb Haemost. 2017;15(10):1951-1962. doi:10.1111/jth.13794
}
\examples{

# Example 1: High Risk (Class IV)
# Active Cancer (+3), Multi-lumen (+1), WBC >12k (+1)
# Score = 5
michigan_picc_risk_score(0, 1, 1, 0, 1)

# Example 2: Low Risk (Class I)
# No risk factors
# Score = 0
michigan_picc_risk_score(0, 0, 0, 0, 0)
}
