\name{mews_score}
\alias{mews_score}
\title{
Modified Early Warning Score (MEWS)
}
\description{
Calculates the Modified Early Warning Score (MEWS), a bedside scoring system used to identify patients at risk of catastrophic clinical deterioration (e.g., cardiac arrest, ICU admission). The score evaluates five physiological parameters: Systolic Blood Pressure, Heart Rate, Respiratory Rate, Temperature, and Level of Consciousness (AVPU).
}
\usage{
mews_score(systolic_bp, heart_rate, respiratory_rate, temp_c, avpu_score)
}
\arguments{
  \item{systolic_bp}{
Numeric. Systolic blood pressure in mmHg.
}
  \item{heart_rate}{
Numeric. Heart rate in beats per minute.
}
  \item{respiratory_rate}{
Numeric. Respiratory rate in breaths per minute.
}
  \item{temp_c}{
Numeric. Body temperature in degrees Celsius.
}
  \item{avpu_score}{
String. Level of consciousness. Options:
"alert": Alert (0 points).
"verbal": Responds to Voice / New Confusion (1 point).
"pain": Responds to Pain (2 points).
"unresponsive": Unresponsive (3 points).
}
}
\value{
A list containing:
\item{MEWS_Score}{The calculated total score (Range 0-14).}
\item{Risk_Level}{Classification (Low, Medium, High).}
\item{Action}{Suggested clinical response based on the score threshold.}
}
\references{
Subbe CP, Kruger M, Rutherford P, Gemmel L. Validation of a modified Early Warning Score in medical admissions. QJM. 2001;94(10):521-526. doi:10.1093/qjmed/94.10.521
}
\examples{

# Example 1: Stable Patient
# SBP 120, HR 70, RR 12, Temp 37, Alert
mews_score(120, 70, 12, 37.0, "alert")

# Example 2: Critical Patient (High Risk)
# SBP 85 (+1), HR 115 (+2), RR 25 (+2), Temp 39 (+2), Verbal (+1)
# Score = 8
mews_score(85, 115, 25, 39.0, "verbal")
}
