\name{mess_score}
\alias{mess_score}
\title{
Mangled Extremity Severity Score (MESS)
}
\description{
Calculates the Mangled Extremity Severity Score (MESS) to assess the viability of a limb following severe trauma. The score sums points from four categories: Skeletal/Soft-Tissue Injury, Limb Ischemia, Shock, and Age. A score of 7 or higher has been historically associated with a need for amputation, though clinical judgment remains paramount.
}
\usage{
mess_score(skeletal_soft_tissue, limb_ischemia, shock, age,
           ischemia_duration_gt_6h = 0)
}
\arguments{
  \item{skeletal_soft_tissue}{
Numeric (1-4). Energy of injury.
1: Low energy (stab, simple fracture, pistol gunshot).
2: Medium energy (open multifragmentary fracture, dislocation).
3: High energy (high-velocity gunshot, crush).
4: Very high energy (gross contamination, soft tissue avulsion).
}
  \item{limb_ischemia}{
Numeric (0-3). Severity of ischemia.
0: None (Pulse present, perfusion normal).
1: Mild (Pulse reduced/absent, perfusion present).
2: Moderate (Pulseless, paresthesias, diminished capillary refill).
3: Advanced (Pulseless, cool, paralyzed, numb/insensate).
}
  \item{shock}{
Numeric (0-2). Hemodynamic status.
0: Normotensive (SBP always > 90 mmHg).
1: Transient hypotension.
2: Persistent hypotension.
}
  \item{age}{
Numeric (0-2). Patient age group.
0: < 30 years.
1: 30-50 years.
2: > 50 years.
}
  \item{ischemia_duration_gt_6h}{
Numeric (0 or 1). Ischemia duration greater than 6 hours? (1 = Yes).
If Yes, the points for the 'limb_ischemia' category are doubled.
}
}
\value{
A list containing:
\item{MESS_Score}{The calculated total score (Range 1-14+).}
\item{Interpretation}{Clinical interpretation regarding salvage versus amputation risk (Cutoff >= 7).}
}
\references{
Johansen K, Daines M, Howey T, Helfet D, Hansen ST Jr. Objective criteria accurately predict amputation following lower extremity trauma. J Trauma. 1990;30(5):568-572.
}
\examples{

# Example 1: High Risk (Amputation Likely)
# High energy (3), Advanced ischemia (3) > 6h (doubled -> 6), Shock (1), Age 30-50 (1)
# Score = 3 + 6 + 1 + 1 = 11
mess_score(3, 3, 1, 1, 1)

# Example 2: Low Risk (Salvage Likely)
# Medium energy (2), Mild ischemia (1) < 6h (1), No shock (0), Age < 30 (0)
# Score = 2 + 1 + 0 + 0 = 3
mess_score(2, 1, 0, 0, 0)
}
