\name{mayo_spn_risk}
\alias{mayo_spn_risk}
\title{
Mayo Clinic Model for Solitary Pulmonary Nodule Malignancy Risk
}
\description{
Calculates the probability of malignancy in a solitary pulmonary nodule (SPN) based on the Mayo Clinic model. The model uses six independent predictors: age, smoking history, extrathoracic cancer history (>5 years prior), nodule diameter, upper lobe location, and spiculation.
}
\usage{
mayo_spn_risk(age, smoking_history, cancer_history_gt_5y, nodule_diameter_mm,
              upper_lobe, spiculation)
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
}
  \item{smoking_history}{
Numeric (0 or 1). Current or former smoker. (1 = Yes).
}
  \item{cancer_history_gt_5y}{
Numeric (0 or 1). History of extrathoracic cancer diagnosed more than 5 years ago. (1 = Yes).
}
  \item{nodule_diameter_mm}{
Numeric. Diameter of the nodule in millimeters.
}
  \item{upper_lobe}{
Numeric (0 or 1). Is the nodule located in an upper lobe? (1 = Yes).
}
  \item{spiculation}{
Numeric (0 or 1). Does the nodule have spiculation on imaging? (1 = Yes).
}
}
\value{
A list containing:
\item{Mayo_Malignancy_Risk_Percent}{The estimated percentage probability that the nodule is malignant.}
\item{Risk_Category}{Classification of risk (Low <5\%, Intermediate 5-65\%, High >65\%).}
}
\references{
Swensen SJ, Silverstein MD, Ilstrup DM, Schleck CD, Edell ES. The probability of malignancy in solitary pulmonary nodules. Application to small radiologically indeterminate nodules. Arch Intern Med. 1997;157(8):849-855.
}
\examples{

# Example 1: High Risk
# 70yo, Smoker, Hx Cancer, 20mm, Upper Lobe, Spiculated
# Log-odds = -6.8272 + 2.737 + 0.7917 + 1.3388 + 2.548 + 0.7838 + 1.0407 = 2.41
# Prob = e^2.41 / (1 + e^2.41) = ~91%
mayo_spn_risk(70, 1, 1, 20, 1, 1)

# Example 2: Low Risk
# 40yo, Non-smoker, No Hx, 5mm, Lower Lobe, Smooth
# Log-odds = -6.8272 + 1.564 + 0 + 0 + 0.637 + 0 + 0 = -4.62
# Prob = ~1%
mayo_spn_risk(40, 0, 0, 5, 0, 0)
}
