\name{manning_ibs_criteria}
\alias{manning_ibs_criteria}
\title{
Manning Criteria for Diagnosis of Irritable Bowel Syndrome (IBS)
}
\description{
Calculates the Manning Score to estimate the likelihood of Irritable Bowel Syndrome (IBS). The score counts the number of positive symptoms out of six specific gastrointestinal complaints. Higher scores correlate with a higher specificity for IBS.
}
\usage{
manning_ibs_criteria(pain_relieved_by_defecation, incomplete_bowel_movement,
                     mucus_in_stool, change_in_stool_consistency,
                     more_frequent_stool_with_pain, abdominal_distension)
}
\arguments{
  \item{pain_relieved_by_defecation}{
Numeric (0 or 1). Abdominal pain relieved by defecation. (1 = Yes).
}
  \item{incomplete_bowel_movement}{
Numeric (0 or 1). Feeling of incomplete bowel movements. (1 = Yes).
}
  \item{mucus_in_stool}{
Numeric (0 or 1). Passage of mucus per rectum. (1 = Yes).
}
  \item{change_in_stool_consistency}{
Numeric (0 or 1). Change in stool consistency (looser stools) with onset of pain. (1 = Yes).
}
  \item{more_frequent_stool_with_pain}{
Numeric (0 or 1). More frequent bowel movements with onset of pain. (1 = Yes).
}
  \item{abdominal_distension}{
Numeric (0 or 1). Visible abdominal distension. (1 = Yes).
}
}
\value{
A list containing:
\item{Manning_Score}{The total count of positive criteria (Range 0-6).}
\item{Interpretation}{Diagnostic likelihood based on the number of criteria met.}
}
\references{
Manning AP, Thompson WG, Heaton KW, Morris AF. Towards positive diagnosis of the irritable bowel. Br Med J. 1978;2(6138):653-654. doi:10.1136/bmj.2.6138.653
}
\examples{

# Example 1: High Likelihood
# Pain relief(1), Incomplete(1), Distension(1), Consistency(1)
# Score = 4
manning_ibs_criteria(1, 1, 0, 1, 0, 1)

# Example 2: Low Likelihood
# Distension only
# Score = 1
manning_ibs_criteria(0, 0, 0, 0, 0, 1)
}
