\name{lrinec_score_necrotizing_infection}
\alias{lrinec_score_necrotizing_infection}
\title{
LRINEC Score for Necrotizing Soft Tissue Infection
}
\description{
Calculates the Laboratory Risk Indicator for Necrotizing Fasciitis (LRINEC) score. This tool uses six independent laboratory predictors (CRP, WBC, Hemoglobin, Sodium, Creatinine, Glucose) to distinguish necrotizing soft tissue infections from severe cellulitis or abscesses.
}
\usage{
lrinec_score_necrotizing_infection(crp_mg_dl, wbc_count, hemoglobin_g_dl,
                                   sodium, creatinine, glucose_mg_dl,
                                   creatinine_units = "mg/dL",
                                   glucose_units = "mg/dL")
}
\arguments{
  \item{crp_mg_dl}{
Numeric. C-Reactive Protein level in mg/dL. (>= 15 mg/dL adds 4 points).
}
  \item{wbc_count}{
Numeric. White Blood Cell count in x10^3/uL (or x10^9/L). (<15: 0, 15-25: 1, >25: 2).
}
  \item{hemoglobin_g_dl}{
Numeric. Hemoglobin level in g/dL. (>13.5: 0, 11-13.5: 1, <11: 2).
}
  \item{sodium}{
Numeric. Serum Sodium level in mEq/L. (<135: 2 pts).
}
  \item{creatinine}{
Numeric. Serum Creatinine level. (>1.6 mg/dL adds 2 pts).
}
  \item{glucose_mg_dl}{
Numeric. Serum Glucose level. (>180 mg/dL adds 1 pt).
}
  \item{creatinine_units}{
String. Units for creatinine. "mg/dL" (default) or "micromol/L".
}
  \item{glucose_units}{
String. Units for glucose. "mg/dL" (default) or "mmol/L".
}
}
\value{
A list containing:
\item{LRINEC_Score}{The calculated score (Range 0-13).}
\item{Risk_Category}{Classification (Low <=5, Intermediate 6-7, High >=8).}
\item{Est_Probability_NSTI}{Estimated probability of Necrotizing Soft Tissue Infection.}
}
\references{
Wong CH, Khin LW, Heng KS, Tan KC, Low CO. The LRINEC (Laboratory Risk Indicator for Necrotizing Fasciitis) score: a tool for distinguishing necrotizing fasciitis from other soft tissue infections. Crit Care Med. 2004;32(7):1535-1541. doi:10.1097/01.ccm.0000129486.35458.7d
}
\examples{

# Example 1: High Risk
# CRP 20 (+4), WBC 28 (+2), Hb 10 (+2), Na 130 (+2), Cr 1.0, Gluc 200 (+1)
# Score = 11
lrinec_score_necrotizing_infection(20, 28, 10, 130, 1.0, 200)

# Example 2: Low Risk
# CRP 5 (0), WBC 12 (0), Hb 14 (0), Na 140 (0), Cr 0.9, Gluc 100 (0)
# Score = 0
lrinec_score_necrotizing_infection(5, 12, 14, 140, 0.9, 100)
}
