\name{karnofsky_performance_status}
\alias{karnofsky_performance_status}
\title{
Karnofsky Performance Status (KPS) Scale
}
\description{
Retrieves the definition and functional category for the Karnofsky Performance Status scale. The KPS allows patients to be classified as to their functional impairment. This can be used to compare effectiveness of different therapies and to assess the prognosis in individual patients.
}
\usage{
karnofsky_performance_status(score)
}
\arguments{
  \item{score}{
Numeric. The KPS score. Must be a multiple of 10 between 0 and 100.
}
}
\value{
A list containing:
\item{KPS_Score}{The input score.}
\item{Definition}{Specific criteria regarding complaints and evidence of disease.}
\item{Functional_Category}{Broad description of ability to work, live at home, or need for institutional care.}
}
\references{
Karnofsky DA, Burchenal JH. The Clinical Evaluation of Chemotherapeutic Agents in Cancer. In: MacLeod CM (Ed), Evaluation of Chemotherapeutic Agents. Columbia Univ Press. 1949:191-205.
}
\examples{

# Example 1: Able to work, minor symptoms
karnofsky_performance_status(90)

# Example 2: Needs frequent medical care
karnofsky_performance_status(50)
}
