\name{idf_dar_fasting_risk}
\alias{idf_dar_fasting_risk}
\title{
IDF-DAR Fasting Risk Assessment for Ramadan
}
\description{
Calculates the risk score for patients with diabetes who intend to fast during Ramadan, based on the International Diabetes Federation (IDF) and Diabetes and Ramadan (DAR) International Alliance guidelines (2021). The score stratifies patients into Low, Moderate, and High risk categories.
}
\usage{
idf_dar_fasting_risk(type_1_diabetes, duration_gt_10_years, hba1c_value,
                     hypoglycemia_points, complication_points, medication_points,
                     smbg_not_performed, pregnancy, frailty_cognitive,
                     intense_labor, previous_ramadan_bad)
}
\arguments{
  \item{type_1_diabetes}{
Numeric (0 or 1). Is the patient Type 1? (1 = Yes, +1 point).
}
  \item{duration_gt_10_years}{
Numeric (0 or 1). Is the duration of diabetes > 10 years? (1 = Yes, +1 point).
}
  \item{hba1c_value}{
Numeric. Current HbA1c percentage. (7.5-9.0: +1 pt; >9.0: +2 pts).
}
  \item{hypoglycemia_points}{
Numeric. Points based on hypoglycemia history:
0: None/Stable.
1: Hypo occurring but stable/aware.
5.5: Recent severe hypoglycemia, hypoglycemia unawareness, or DKA/HHS within 3 months.
}
  \item{complication_points}{
Numeric. Sum of points for complications:
0: None.
2: Stable cardiovascular disease.
4: Unstable CVD, Heart Failure, Stroke.
4: Renal impairment eGFR 30-60.
5.5: eGFR < 30 or Dialysis.
}
  \item{medication_points}{
Numeric. Sum of points for medications used:
0: Metformin, TZD, GLP-1, DPP-4.
0.5: Sulfonylurea (2nd gen), SGLT2 inhibitors (monitor DKA).
1: Glibenclamide (long-acting SU).
1.5: Basal insulin.
2.0: Premix insulin (once daily).
3.0: Multiple dose insulin (MDI) or Pump.
}
  \item{smbg_not_performed}{
Numeric (0 or 1). Self-monitoring of blood glucose (SMBG) is NOT performed? (1 = Yes, +2 points).
}
  \item{pregnancy}{
Numeric (0 or 1). Is the patient pregnant? (1 = Yes, +6.5 points).
}
  \item{frailty_cognitive}{
Numeric (0 or 1). Frailty, cognitive impairment, or living alone without support? (1 = Yes, +5.5 points).
}
  \item{intense_labor}{
Numeric (0 or 1). Does the patient perform intense physical labor? (1 = Yes, +1 point).
}
  \item{previous_ramadan_bad}{
Numeric (0 or 1). Previous negative experience (e.g., admission, severe hypo) during Ramadan? (1 = Yes, +1 point).
}
}
\value{
A list containing:
\item{Total_Risk_Score}{The calculated risk score.}
\item{Risk_Category}{Classification (Low <=3, Moderate 3.5-6, High >6).}
\item{Recommendation}{Guidance on fasting safety.}
}
\references{
International Diabetes Federation and the DAR International Alliance. Diabetes and Ramadan: Practical Guidelines, 2021.
}
\examples{

# Example 1: Low Risk T2DM
# T2 (0), <10y (0), A1c 7.0 (0), No Hypo (0), No Comps (0), Metformin (0)
idf_dar_fasting_risk(0, 0, 7.0, 0, 0, 0, 0, 0, 0, 0, 0)

# Example 2: High Risk T1DM
# T1 (1), >10y (1), A1c 9.5 (2), MDI (3), Recent Hypo (5.5)
# Score = 12.5
idf_dar_fasting_risk(1, 1, 9.5, 5.5, 0, 3, 0, 0, 0, 0, 0)
}
