\name{hct_ci_score}
\alias{hct_ci_score}
\title{
Hematopoietic Cell Transplantation-Specific Comorbidity Index (HCT-CI)
}
\description{
Calculates the HCT-CI score, a tool designed to assess comorbidities in patients undergoing hematopoietic cell transplantation. It predicts non-relapse mortality (NRM) and overall survival better than the Charlson Comorbidity Index in this population.
}
\usage{
hct_ci_score(arrhythmia, cardiac_comorbidity, ibd, diabetes, cerebrovascular,
             psychiatric, hepatic_mild, hepatic_severe, obesity, infection,
             rheumatologic, peptic_ulcer, renal_moderate_severe,
             pulmonary_moderate, pulmonary_severe, prior_solid_tumor,
             heart_valve_disease)
}
\arguments{
  \item{arrhythmia}{Numeric (0 or 1). Atrial fibrillation/flutter, sick sinus syndrome, or ventricular arrhythmias. (1 pt).}
  \item{cardiac_comorbidity}{Numeric (0 or 1). Coronary artery disease, CHF, MI, or EF < 50\%. (1 pt).}
  \item{ibd}{Numeric (0 or 1). Inflammatory bowel disease (Crohn's/UC). (1 pt).}
  \item{diabetes}{Numeric (0 or 1). Diabetes or steroid-induced hyperglycemia requiring treatment. (1 pt).}
  \item{cerebrovascular}{Numeric (0 or 1). TIA or CVA. (1 pt).}
  \item{psychiatric}{Numeric (0 or 1). Depression/anxiety requiring psychiatric consult or treatment. (1 pt).}
  \item{hepatic_mild}{Numeric (0 or 1). Mild hepatic disease (Bilirubin > ULN to 1.5x ULN, or AST/ALT > ULN to 2.5x ULN). (1 pt).}
  \item{hepatic_severe}{Numeric (0 or 1). Moderate/Severe hepatic disease (Bili > 1.5x ULN, AST/ALT > 2.5x ULN, or cirrhosis). (3 pts).}
  \item{obesity}{Numeric (0 or 1). BMI > 35 kg/m^2. (1 pt).}
  \item{infection}{Numeric (0 or 1). Infection requiring continuation of antimicrobials after day 0. (1 pt).}
  \item{rheumatologic}{Numeric (0 or 1). SLE, RA, polymyositis, mixed CTD, polymyalgia rheumatica. (2 pts).}
  \item{peptic_ulcer}{Numeric (0 or 1). Peptic ulcer disease requiring treatment. (2 pts).}
  \item{renal_moderate_severe}{Numeric (0 or 1). Serum creatinine > 2 mg/dL, dialysis, or renal transplant. (2 pts).}
  \item{pulmonary_moderate}{Numeric (0 or 1). DLCO and/or FEV1 66-80\% or dyspnea on slight activity. (2 pts).}
  \item{pulmonary_severe}{Numeric (0 or 1). DLCO and/or FEV1 <= 65\% or dyspnea at rest/on O2. (3 pts).}
  \item{prior_solid_tumor}{Numeric (0 or 1). Prior solid tumor treated at any time point (excluding non-melanoma skin cancer). (3 pts).}
  \item{heart_valve_disease}{Numeric (0 or 1). Moderate to severe valve abnormality (except MVP). (3 pts).}
}
\value{
A list containing:
\item{HCT_CI_Score}{The calculated score (Range 0-27+).}
\item{Risk_Group}{Classification (Low 0, Intermediate 1-2, High >=3).}
\item{Est_2Yr_Non_Relapse_Mortality}{Estimated 2-year NRM percentage.}
\item{Est_2Yr_Overall_Survival}{Estimated 2-year Overall Survival percentage.}
}
\references{
Sorror ML, Maris MB, Storb R, et al. Hematopoietic cell transplantation-specific comorbidity index: a new tool for risk assessment before allogeneic HCT. Blood. 2005;106(8):2912-2919. doi:10.1182/blood-2005-05-2004
}
\examples{

# Example 1: High Risk
# Diabetes (1), Severe Pulmonary (3)
# Score = 4
hct_ci_score(0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0)

# Example 2: Intermediate Risk
# Obesity (1), Mild Hepatic (1)
# Score = 2
hct_ci_score(0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0)
}
