\name{harvey_bradshaw_index}
\alias{harvey_bradshaw_index}
\title{
Harvey-Bradshaw Index (HBI) for Crohn's Disease
}
\description{
Calculates the Harvey-Bradshaw Index (HBI), a simpler alternative to the Crohn's Disease Activity Index (CDAI) for assessing disease activity. It relies on five clinical parameters collected over the previous day (or short period) rather than the 7-day diary required by the CDAI.
}
\usage{
harvey_bradshaw_index(general_wellbeing, abdominal_pain, liquid_stools_daily,
                      abdominal_mass, complications_count)
}
\arguments{
  \item{general_wellbeing}{
Numeric (0-4). Patient's general well-being.
0: Very well.
1: Slightly below par.
2: Poor.
3: Very poor.
4: Terrible.
}
  \item{abdominal_pain}{
Numeric (0-3). Abdominal pain.
0: None.
1: Mild.
2: Moderate.
3: Severe.
}
  \item{liquid_stools_daily}{
Numeric. Number of liquid or soft stools per day. (1 point per stool).
}
  \item{abdominal_mass}{
Numeric (0-3). Abdominal mass.
0: None.
1: Dubious.
2: Definite.
3: Definite and tender.
}
  \item{complications_count}{
Numeric. Count of specific complications (1 point for each): Arthralgia, Uveitis, Erythema nodosum, Aphthous ulcers, Pyoderma gangrenosum, Anal fissure, New fistula, Abscess.
}
}
\value{
A list containing:
\item{HBI_Score}{The calculated total score.}
\item{Disease_Activity}{Classification (Remission < 5, Mild 5-7, Moderate 8-16, Severe > 16).}
}
\references{
Harvey RF, Bradshaw JM. A simple index of Crohn's-disease activity. Lancet. 1980;1(8167):514. doi:10.1016/s0140-6736(80)92767-1
}
\examples{

# Example 1: Remission
# Well (0), No pain (0), 1 stool, No mass (0), No complications
# Score = 1
harvey_bradshaw_index(0, 0, 1, 0, 0)

# Example 2: Moderate Activity
# Poor well-being (2), Moderate pain (2), 5 stools, No mass (0), 1 Complication
# Score = 2 + 2 + 5 + 0 + 1 = 10
harvey_bradshaw_index(2, 2, 5, 0, 1)
}
