\name{glasgow_imrie_pancreatitis_score}
\alias{glasgow_imrie_pancreatitis_score}
\title{
Glasgow-Imrie Criteria for Acute Pancreatitis Severity
}
\description{
Calculates the Glasgow-Imrie Score (Modified Glasgow Score) to assess the severity of acute pancreatitis within the first 48 hours of admission. The score utilizes the mnemonic PANCREAS to evaluate 8 prognostic factors. A score of 3 or greater indicates severe pancreatitis.
}
\usage{
glasgow_imrie_pancreatitis_score(age, wbc, glucose, urea, pao2, albumin,
                                 calcium, ldh, ast, alt,
                                 glucose_units = "mmol/L",
                                 urea_units = "mmol/L",
                                 calcium_units = "mmol/L",
                                 albumin_units = "g/L")
}
\arguments{
  \item{age}{
Numeric. Patient age in years. (> 55 years adds 1 point).
}
  \item{wbc}{
Numeric. White Blood Cell count (x 10^9/L). (> 15 adds 1 point).
}
  \item{glucose}{
Numeric. Serum glucose level. (> 10 mmol/L or 180 mg/dL adds 1 point).
}
  \item{urea}{
Numeric. Serum Urea level. (> 16 mmol/L or ~45 mg/dL BUN adds 1 point).
}
  \item{pao2}{
Numeric. Arterial partial pressure of oxygen (mmHg). (< 60 mmHg adds 1 point).
}
  \item{albumin}{
Numeric. Serum albumin level. (< 32 g/L or 3.2 g/dL adds 1 point).
}
  \item{calcium}{
Numeric. Serum calcium level. (< 2.0 mmol/L or 8.0 mg/dL adds 1 point).
}
  \item{ldh}{
Numeric. Lactate dehydrogenase (U/L). (> 600 U/L adds 1 point as part of Enzyme criteria).
}
  \item{ast}{
Numeric. Aspartate aminotransferase (U/L). (> 200 U/L adds 1 point as part of Enzyme criteria).
}
  \item{alt}{
Numeric. Alanine aminotransferase (U/L). (> 200 U/L adds 1 point as part of Enzyme criteria).
}
  \item{glucose_units}{
String. "mmol/L" (default) or "mg/dL".
}
  \item{urea_units}{
String. "mmol/L" (default) or "mg/dL" (treats input as BUN).
}
  \item{calcium_units}{
String. "mmol/L" (default) or "mg/dL".
}
  \item{albumin_units}{
String. "g/L" (default) or "g/dL".
}
}
\value{
A list containing:
\item{Glasgow_Imrie_Score}{The calculated score (Range 0-8).}
\item{Severity_Assessment}{"Severe Pancreatitis" if Score >= 3, otherwise "Mild Pancreatitis".}
}
\references{
Blamey SL, Imrie CW, O'Neill J, Gilmour WH, Carter DC. Prognostic factors in acute pancreatitis. Gut. 1984;25(12):1340-1346. doi:10.1136/gut.25.12.1340
}
\examples{

# Example 1: Severe Pancreatitis
# Age 60 (+1), WBC 18 (+1), Glucose 12 mmol (+1), LDH 700 (+1)
# Score = 4
glasgow_imrie_pancreatitis_score(60, 18, 12, 10, 70, 35, 2.2, 700, 100, 100)

# Example 2: Mild Pancreatitis
# 40yo, Normal labs except slightly low calcium
# Score = 1
glasgow_imrie_pancreatitis_score(40, 8, 5, 5, 90, 40, 1.9, 200, 30, 30)
}
