\name{glasgow_blatchford_score}
\alias{glasgow_blatchford_score}
\title{
Glasgow-Blatchford Bleeding Score (GBS)
}
\description{
Calculates the Glasgow-Blatchford Score (GBS) to screen patients with upper gastrointestinal bleeding (UGIB). The score identifies low-risk patients who may be safely managed as outpatients. A score of 0 indicates low risk for needing medical intervention (transfusion, endoscopy, surgery).
}
\usage{
glasgow_blatchford_score(bun, hemoglobin, systolic_bp, heart_rate, melena,
                         syncope, liver_disease, cardiac_failure, bun_units = "mg/dL")
}
\arguments{
  \item{bun}{
Numeric. Blood Urea Nitrogen level.
6.5-7.9 mg/dL: +2.
8.0-9.9 mg/dL: +3.
10.0-24.9 mg/dL: +4.
>=25.0 mg/dL: +6.
}
  \item{hemoglobin}{
Numeric. Hemoglobin level in g/dL.
12.0-12.9 (Men): +1.
10.0-11.9 (Men/Women): +3.
<10.0: +6.
}
  \item{systolic_bp}{
Numeric. Systolic Blood Pressure in mmHg.
100-109: +1.
90-99: +2.
<90: +3.
}
  \item{heart_rate}{
Numeric. Heart Rate in bpm. (>= 100: +1 point).
}
  \item{melena}{
Numeric (0 or 1). Presence of melena. (1 = Yes, +1 point).
}
  \item{syncope}{
Numeric (0 or 1). Presentation with syncope. (1 = Yes, +2 points).
}
  \item{liver_disease}{
Numeric (0 or 1). History of hepatic disease. (1 = Yes, +2 points).
}
  \item{cardiac_failure}{
Numeric (0 or 1). History of cardiac failure. (1 = Yes, +2 points).
}
  \item{bun_units}{
String. Units for BUN input. "mg/dL" (default) or "mmol/L".
}
}
\value{
A list containing:
\item{GBS_Score}{The calculated score (Range 0-23).}
\item{Risk_Category}{Interpretation ("Low Risk" if 0, otherwise "High Risk").}
}
\references{
Blatchford O, Murray WR, Blatchford M. A risk score to predict need for treatment for upper-gastrointestinal haemorrhage. Lancet. 2000;356(9238):1318-1321. doi:10.1016/S0140-6736(00)02816-6
}
\examples{

# Example 1: Low Risk
# BUN 5, Hb 14, SBP 120, HR 70, No other factors
# Score = 0
glasgow_blatchford_score(5, 14, 120, 70, 0, 0, 0, 0)

# Example 2: High Risk
# BUN 30 (+6), Hb 9 (+6), Melena (+1)
# Score = 13
glasgow_blatchford_score(30, 9, 110, 90, 1, 0, 0, 0)
}
